<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cPerson StructType
 * @subpackage Structs
 */
class CPerson extends AbstractStructBase
{
    /**
     * The adresse
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \booking-assistent\StructType\CAdresse
     */
    public $adresse;
    /**
     * The personid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $personid;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $geburtsdatum;
    /**
     * The staatsangehoerigkeitid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CLand
     */
    public $staatsangehoerigkeitid;
    /**
     * The kategorieid
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $kategorieid;
    /**
     * The anreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $anreise;
    /**
     * The abreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $abreise;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * Constructor method for cPerson
     * @uses CPerson::setAdresse()
     * @uses CPerson::setPersonid()
     * @uses CPerson::setGeburtsdatum()
     * @uses CPerson::setStaatsangehoerigkeitid()
     * @uses CPerson::setKategorieid()
     * @uses CPerson::setAnreise()
     * @uses CPerson::setAbreise()
     * @uses CPerson::setBarcode()
     * @param \booking-assistent\StructType\CAdresse $adresse
     * @param int $personid
     * @param string $geburtsdatum
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeitid
     * @param int $kategorieid
     * @param string $anreise
     * @param string $abreise
     * @param string $barcode
     */
    public function __construct(\booking-assistent\StructType\CAdresse $adresse = null, $personid = null, $geburtsdatum = null, \booking-assistent\StructType\CLand $staatsangehoerigkeitid = null, $kategorieid = null, $anreise = null, $abreise = null, $barcode = null)
    {
        $this
            ->setAdresse($adresse)
            ->setPersonid($personid)
            ->setGeburtsdatum($geburtsdatum)
            ->setStaatsangehoerigkeitid($staatsangehoerigkeitid)
            ->setKategorieid($kategorieid)
            ->setAnreise($anreise)
            ->setAbreise($abreise)
            ->setBarcode($barcode);
    }
    /**
     * Get adresse value
     * @return \booking-assistent\StructType\CAdresse
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \booking-assistent\StructType\CAdresse $adresse
     * @return \booking-assistent\StructType\CPerson
     */
    public function setAdresse(\booking-assistent\StructType\CAdresse $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Get personid value
     * @return int|null
     */
    public function getPersonid()
    {
        return $this->personid;
    }
    /**
     * Set personid value
     * @param int $personid
     * @return \booking-assistent\StructType\CPerson
     */
    public function setPersonid($personid = null)
    {
        // validation for constraint: int
        if (!is_null($personid) && !(is_int($personid) || ctype_digit($personid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personid, true), gettype($personid)), __LINE__);
        }
        $this->personid = $personid;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \booking-assistent\StructType\CPerson
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get staatsangehoerigkeitid value
     * @return \booking-assistent\StructType\CLand|null
     */
    public function getStaatsangehoerigkeitid()
    {
        return $this->staatsangehoerigkeitid;
    }
    /**
     * Set staatsangehoerigkeitid value
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeitid
     * @return \booking-assistent\StructType\CPerson
     */
    public function setStaatsangehoerigkeitid(\booking-assistent\StructType\CLand $staatsangehoerigkeitid = null)
    {
        $this->staatsangehoerigkeitid = $staatsangehoerigkeitid;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * Set kategorieid value
     * @param int $kategorieid
     * @return \booking-assistent\StructType\CPerson
     */
    public function setKategorieid($kategorieid = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid) && !(is_int($kategorieid) || ctype_digit($kategorieid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid, true), gettype($kategorieid)), __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Get anreise value
     * @return string|null
     */
    public function getAnreise()
    {
        return $this->anreise;
    }
    /**
     * Set anreise value
     * @param string $anreise
     * @return \booking-assistent\StructType\CPerson
     */
    public function setAnreise($anreise = null)
    {
        // validation for constraint: string
        if (!is_null($anreise) && !is_string($anreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anreise, true), gettype($anreise)), __LINE__);
        }
        $this->anreise = $anreise;
        return $this;
    }
    /**
     * Get abreise value
     * @return string|null
     */
    public function getAbreise()
    {
        return $this->abreise;
    }
    /**
     * Set abreise value
     * @param string $abreise
     * @return \booking-assistent\StructType\CPerson
     */
    public function setAbreise($abreise = null)
    {
        // validation for constraint: string
        if (!is_null($abreise) && !is_string($abreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abreise, true), gettype($abreise)), __LINE__);
        }
        $this->abreise = $abreise;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \booking-assistent\StructType\CPerson
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
}
