<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cMs StructType
 * @subpackage Structs
 */
class CMs extends AbstractStructBase
{
    /**
     * The buchungsnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $buchungsnummer;
    /**
     * The kz_manuelle_ms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $kz_manuelle_ms;
    /**
     * The meldescheinnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $meldescheinnummer;
    /**
     * The firmaid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $firmaid;
    /**
     * The objektid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $objektid;
    /**
     * The anreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * @var string
     */
    public $anreise;
    /**
     * The abreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * @var string
     */
    public $abreise;
    /**
     * The kategorieid
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $kategorieid;
    /**
     * The anredeid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $anredeid;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $hausnummer;
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $ort;
    /**
     * The landid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $landid;
    /**
     * The land
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CLand
     */
    public $land;
    /**
     * The staatsangehoerigkeitid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $staatsangehoerigkeitid;
    /**
     * The staatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CLand
     */
    public $staatsangehoerigkeit;
    /**
     * The ausweisnr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ausweisnr;
    /**
     * The weitere_angaben
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $weitere_angaben;
    /**
     * The kfzkennzeichen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kfzkennzeichen;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $geburtsdatum;
    /**
     * The manueller_betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $manueller_betrag;
    /**
     * The betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $betrag;
    /**
     * The abrechnungstatusid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 0
     * @var int
     */
    public $abrechnungstatusid;
    /**
     * The zusatzfelder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CMeldescheinZusatzfelder
     */
    public $zusatzfelder;
    /**
     * The indiv_zusatzfelder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CIndivZusatzfelder[]
     */
    public $indiv_zusatzfelder;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The digit_gastkart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $digit_gastkart;
    /**
     * The ue_e_gelt
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $ue_e_gelt;
    /**
     * The authentifizierung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authentifizierung;
    /**
     * The weitere_kosten
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $weitere_kosten;
    /**
     * The begleitperson
     * Meta information extracted from the WSDL
     * - choice: begleitperson | begleitgruppe
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CBegleitperson[]
     */
    public $begleitperson;
    /**
     * The begleitgruppe
     * Meta information extracted from the WSDL
     * - choice: begleitperson | begleitgruppe
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CBegleitgruppe[]
     */
    public $begleitgruppe;
    /**
     * Constructor method for cMs
     * @uses CMs::setBuchungsnummer()
     * @uses CMs::setKz_manuelle_ms()
     * @uses CMs::setMeldescheinnummer()
     * @uses CMs::setFirmaid()
     * @uses CMs::setObjektid()
     * @uses CMs::setAnreise()
     * @uses CMs::setAbreise()
     * @uses CMs::setKategorieid()
     * @uses CMs::setAnredeid()
     * @uses CMs::setName()
     * @uses CMs::setVorname()
     * @uses CMs::setStrasse()
     * @uses CMs::setHausnummer()
     * @uses CMs::setPlz()
     * @uses CMs::setOrt()
     * @uses CMs::setLandid()
     * @uses CMs::setLand()
     * @uses CMs::setStaatsangehoerigkeitid()
     * @uses CMs::setStaatsangehoerigkeit()
     * @uses CMs::setAusweisnr()
     * @uses CMs::setWeitere_angaben()
     * @uses CMs::setKfzkennzeichen()
     * @uses CMs::setGeburtsdatum()
     * @uses CMs::setManueller_betrag()
     * @uses CMs::setBetrag()
     * @uses CMs::setAbrechnungstatusid()
     * @uses CMs::setZusatzfelder()
     * @uses CMs::setIndiv_zusatzfelder()
     * @uses CMs::setEmail()
     * @uses CMs::setDigit_gastkart()
     * @uses CMs::setUe_e_gelt()
     * @uses CMs::setAuthentifizierung()
     * @uses CMs::setWeitere_kosten()
     * @uses CMs::setBegleitperson()
     * @uses CMs::setBegleitgruppe()
     * @param string $buchungsnummer
     * @param bool $kz_manuelle_ms
     * @param string $meldescheinnummer
     * @param int $firmaid
     * @param int $objektid
     * @param string $anreise
     * @param string $abreise
     * @param int $kategorieid
     * @param int $anredeid
     * @param string $name
     * @param string $vorname
     * @param string $strasse
     * @param string $hausnummer
     * @param string $plz
     * @param string $ort
     * @param int $landid
     * @param \booking-assistent\StructType\CLand $land
     * @param int $staatsangehoerigkeitid
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeit
     * @param string $ausweisnr
     * @param string $weitere_angaben
     * @param string $kfzkennzeichen
     * @param string $geburtsdatum
     * @param float $manueller_betrag
     * @param float $betrag
     * @param int $abrechnungstatusid
     * @param \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder
     * @param \booking-assistent\StructType\CIndivZusatzfelder[] $indiv_zusatzfelder
     * @param string $email
     * @param bool $digit_gastkart
     * @param float $ue_e_gelt
     * @param string $authentifizierung
     * @param float $weitere_kosten
     * @param \booking-assistent\StructType\CBegleitperson[] $begleitperson
     * @param \booking-assistent\StructType\CBegleitgruppe[] $begleitgruppe
     */
    public function __construct($buchungsnummer = null, $kz_manuelle_ms = null, $meldescheinnummer = null, $firmaid = null, $objektid = null, $anreise = null, $abreise = null, $kategorieid = null, $anredeid = null, $name = null, $vorname = null, $strasse = null, $hausnummer = null, $plz = null, $ort = null, $landid = null, \booking-assistent\StructType\CLand $land = null, $staatsangehoerigkeitid = null, \booking-assistent\StructType\CLand $staatsangehoerigkeit = null, $ausweisnr = null, $weitere_angaben = null, $kfzkennzeichen = null, $geburtsdatum = null, $manueller_betrag = null, $betrag = null, $abrechnungstatusid = null, \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder = null, array $indiv_zusatzfelder = array(), $email = null, $digit_gastkart = null, $ue_e_gelt = null, $authentifizierung = null, $weitere_kosten = null, array $begleitperson = array(), array $begleitgruppe = array())
    {
        $this
            ->setBuchungsnummer($buchungsnummer)
            ->setKz_manuelle_ms($kz_manuelle_ms)
            ->setMeldescheinnummer($meldescheinnummer)
            ->setFirmaid($firmaid)
            ->setObjektid($objektid)
            ->setAnreise($anreise)
            ->setAbreise($abreise)
            ->setKategorieid($kategorieid)
            ->setAnredeid($anredeid)
            ->setName($name)
            ->setVorname($vorname)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setLandid($landid)
            ->setLand($land)
            ->setStaatsangehoerigkeitid($staatsangehoerigkeitid)
            ->setStaatsangehoerigkeit($staatsangehoerigkeit)
            ->setAusweisnr($ausweisnr)
            ->setWeitere_angaben($weitere_angaben)
            ->setKfzkennzeichen($kfzkennzeichen)
            ->setGeburtsdatum($geburtsdatum)
            ->setManueller_betrag($manueller_betrag)
            ->setBetrag($betrag)
            ->setAbrechnungstatusid($abrechnungstatusid)
            ->setZusatzfelder($zusatzfelder)
            ->setIndiv_zusatzfelder($indiv_zusatzfelder)
            ->setEmail($email)
            ->setDigit_gastkart($digit_gastkart)
            ->setUe_e_gelt($ue_e_gelt)
            ->setAuthentifizierung($authentifizierung)
            ->setWeitere_kosten($weitere_kosten)
            ->setBegleitperson($begleitperson)
            ->setBegleitgruppe($begleitgruppe);
    }
    /**
     * Get buchungsnummer value
     * @return string|null
     */
    public function getBuchungsnummer()
    {
        return $this->buchungsnummer;
    }
    /**
     * Set buchungsnummer value
     * @param string $buchungsnummer
     * @return \booking-assistent\StructType\CMs
     */
    public function setBuchungsnummer($buchungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($buchungsnummer) && !is_string($buchungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buchungsnummer, true), gettype($buchungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($buchungsnummer) && mb_strlen($buchungsnummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($buchungsnummer)), __LINE__);
        }
        $this->buchungsnummer = $buchungsnummer;
        return $this;
    }
    /**
     * Get kz_manuelle_ms value
     * @return bool|null
     */
    public function getKz_manuelle_ms()
    {
        return $this->kz_manuelle_ms;
    }
    /**
     * Set kz_manuelle_ms value
     * @param bool $kz_manuelle_ms
     * @return \booking-assistent\StructType\CMs
     */
    public function setKz_manuelle_ms($kz_manuelle_ms = null)
    {
        // validation for constraint: boolean
        if (!is_null($kz_manuelle_ms) && !is_bool($kz_manuelle_ms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kz_manuelle_ms, true), gettype($kz_manuelle_ms)), __LINE__);
        }
        $this->kz_manuelle_ms = $kz_manuelle_ms;
        return $this;
    }
    /**
     * Get meldescheinnummer value
     * @return string|null
     */
    public function getMeldescheinnummer()
    {
        return $this->meldescheinnummer;
    }
    /**
     * Set meldescheinnummer value
     * @param string $meldescheinnummer
     * @return \booking-assistent\StructType\CMs
     */
    public function setMeldescheinnummer($meldescheinnummer = null)
    {
        // validation for constraint: string
        if (!is_null($meldescheinnummer) && !is_string($meldescheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldescheinnummer, true), gettype($meldescheinnummer)), __LINE__);
        }
        $this->meldescheinnummer = $meldescheinnummer;
        return $this;
    }
    /**
     * Get firmaid value
     * @return int|null
     */
    public function getFirmaid()
    {
        return $this->firmaid;
    }
    /**
     * Set firmaid value
     * @param int $firmaid
     * @return \booking-assistent\StructType\CMs
     */
    public function setFirmaid($firmaid = null)
    {
        // validation for constraint: int
        if (!is_null($firmaid) && !(is_int($firmaid) || ctype_digit($firmaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firmaid, true), gettype($firmaid)), __LINE__);
        }
        $this->firmaid = $firmaid;
        return $this;
    }
    /**
     * Get objektid value
     * @return int|null
     */
    public function getObjektid()
    {
        return $this->objektid;
    }
    /**
     * Set objektid value
     * @param int $objektid
     * @return \booking-assistent\StructType\CMs
     */
    public function setObjektid($objektid = null)
    {
        // validation for constraint: int
        if (!is_null($objektid) && !(is_int($objektid) || ctype_digit($objektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objektid, true), gettype($objektid)), __LINE__);
        }
        $this->objektid = $objektid;
        return $this;
    }
    /**
     * Get anreise value
     * @return string|null
     */
    public function getAnreise()
    {
        return $this->anreise;
    }
    /**
     * Set anreise value
     * @param string $anreise
     * @return \booking-assistent\StructType\CMs
     */
    public function setAnreise($anreise = null)
    {
        // validation for constraint: string
        if (!is_null($anreise) && !is_string($anreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anreise, true), gettype($anreise)), __LINE__);
        }
        $this->anreise = $anreise;
        return $this;
    }
    /**
     * Get abreise value
     * @return string|null
     */
    public function getAbreise()
    {
        return $this->abreise;
    }
    /**
     * Set abreise value
     * @param string $abreise
     * @return \booking-assistent\StructType\CMs
     */
    public function setAbreise($abreise = null)
    {
        // validation for constraint: string
        if (!is_null($abreise) && !is_string($abreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abreise, true), gettype($abreise)), __LINE__);
        }
        $this->abreise = $abreise;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * Set kategorieid value
     * @param int $kategorieid
     * @return \booking-assistent\StructType\CMs
     */
    public function setKategorieid($kategorieid = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid) && !(is_int($kategorieid) || ctype_digit($kategorieid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid, true), gettype($kategorieid)), __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \booking-assistent\StructType\CMs
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \booking-assistent\StructType\CMs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \booking-assistent\StructType\CMs
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \booking-assistent\StructType\CMs
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($strasse) && mb_strlen($strasse) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \booking-assistent\StructType\CMs
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \booking-assistent\StructType\CMs
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($plz) && mb_strlen($plz) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \booking-assistent\StructType\CMs
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ort) && mb_strlen($ort) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get landid value
     * @return int|null
     */
    public function getLandid()
    {
        return $this->landid;
    }
    /**
     * Set landid value
     * @param int $landid
     * @return \booking-assistent\StructType\CMs
     */
    public function setLandid($landid = null)
    {
        // validation for constraint: int
        if (!is_null($landid) && !(is_int($landid) || ctype_digit($landid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landid, true), gettype($landid)), __LINE__);
        }
        $this->landid = $landid;
        return $this;
    }
    /**
     * Get land value
     * @return \booking-assistent\StructType\CLand|null
     */
    public function getLand()
    {
        return $this->land;
    }
    /**
     * Set land value
     * @param \booking-assistent\StructType\CLand $land
     * @return \booking-assistent\StructType\CMs
     */
    public function setLand(\booking-assistent\StructType\CLand $land = null)
    {
        $this->land = $land;
        return $this;
    }
    /**
     * Get staatsangehoerigkeitid value
     * @return int|null
     */
    public function getStaatsangehoerigkeitid()
    {
        return $this->staatsangehoerigkeitid;
    }
    /**
     * Set staatsangehoerigkeitid value
     * @param int $staatsangehoerigkeitid
     * @return \booking-assistent\StructType\CMs
     */
    public function setStaatsangehoerigkeitid($staatsangehoerigkeitid = null)
    {
        // validation for constraint: int
        if (!is_null($staatsangehoerigkeitid) && !(is_int($staatsangehoerigkeitid) || ctype_digit($staatsangehoerigkeitid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staatsangehoerigkeitid, true), gettype($staatsangehoerigkeitid)), __LINE__);
        }
        $this->staatsangehoerigkeitid = $staatsangehoerigkeitid;
        return $this;
    }
    /**
     * Get staatsangehoerigkeit value
     * @return \booking-assistent\StructType\CLand|null
     */
    public function getStaatsangehoerigkeit()
    {
        return $this->staatsangehoerigkeit;
    }
    /**
     * Set staatsangehoerigkeit value
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeit
     * @return \booking-assistent\StructType\CMs
     */
    public function setStaatsangehoerigkeit(\booking-assistent\StructType\CLand $staatsangehoerigkeit = null)
    {
        $this->staatsangehoerigkeit = $staatsangehoerigkeit;
        return $this;
    }
    /**
     * Get ausweisnr value
     * @return string|null
     */
    public function getAusweisnr()
    {
        return $this->ausweisnr;
    }
    /**
     * Set ausweisnr value
     * @param string $ausweisnr
     * @return \booking-assistent\StructType\CMs
     */
    public function setAusweisnr($ausweisnr = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnr) && !is_string($ausweisnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnr, true), gettype($ausweisnr)), __LINE__);
        }
        $this->ausweisnr = $ausweisnr;
        return $this;
    }
    /**
     * Get weitere_angaben value
     * @return string|null
     */
    public function getWeitere_angaben()
    {
        return $this->weitere_angaben;
    }
    /**
     * Set weitere_angaben value
     * @param string $weitere_angaben
     * @return \booking-assistent\StructType\CMs
     */
    public function setWeitere_angaben($weitere_angaben = null)
    {
        // validation for constraint: string
        if (!is_null($weitere_angaben) && !is_string($weitere_angaben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weitere_angaben, true), gettype($weitere_angaben)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($weitere_angaben) && mb_strlen($weitere_angaben) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($weitere_angaben)), __LINE__);
        }
        $this->weitere_angaben = $weitere_angaben;
        return $this;
    }
    /**
     * Get kfzkennzeichen value
     * @return string|null
     */
    public function getKfzkennzeichen()
    {
        return $this->kfzkennzeichen;
    }
    /**
     * Set kfzkennzeichen value
     * @param string $kfzkennzeichen
     * @return \booking-assistent\StructType\CMs
     */
    public function setKfzkennzeichen($kfzkennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($kfzkennzeichen) && !is_string($kfzkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kfzkennzeichen, true), gettype($kfzkennzeichen)), __LINE__);
        }
        $this->kfzkennzeichen = $kfzkennzeichen;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \booking-assistent\StructType\CMs
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get manueller_betrag value
     * @return float|null
     */
    public function getManueller_betrag()
    {
        return $this->manueller_betrag;
    }
    /**
     * Set manueller_betrag value
     * @param float $manueller_betrag
     * @return \booking-assistent\StructType\CMs
     */
    public function setManueller_betrag($manueller_betrag = null)
    {
        // validation for constraint: float
        if (!is_null($manueller_betrag) && !(is_float($manueller_betrag) || is_numeric($manueller_betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manueller_betrag, true), gettype($manueller_betrag)), __LINE__);
        }
        $this->manueller_betrag = $manueller_betrag;
        return $this;
    }
    /**
     * Get betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    /**
     * Set betrag value
     * @param float $betrag
     * @return \booking-assistent\StructType\CMs
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        $this->betrag = $betrag;
        return $this;
    }
    /**
     * Get abrechnungstatusid value
     * @return int|null
     */
    public function getAbrechnungstatusid()
    {
        return $this->abrechnungstatusid;
    }
    /**
     * Set abrechnungstatusid value
     * @param int $abrechnungstatusid
     * @return \booking-assistent\StructType\CMs
     */
    public function setAbrechnungstatusid($abrechnungstatusid = null)
    {
        // validation for constraint: int
        if (!is_null($abrechnungstatusid) && !(is_int($abrechnungstatusid) || ctype_digit($abrechnungstatusid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abrechnungstatusid, true), gettype($abrechnungstatusid)), __LINE__);
        }
        $this->abrechnungstatusid = $abrechnungstatusid;
        return $this;
    }
    /**
     * Get zusatzfelder value
     * @return \booking-assistent\StructType\CMeldescheinZusatzfelder|null
     */
    public function getZusatzfelder()
    {
        return $this->zusatzfelder;
    }
    /**
     * Set zusatzfelder value
     * @param \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder
     * @return \booking-assistent\StructType\CMs
     */
    public function setZusatzfelder(\booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder = null)
    {
        $this->zusatzfelder = $zusatzfelder;
        return $this;
    }
    /**
     * Get indiv_zusatzfelder value
     * @return \booking-assistent\StructType\CIndivZusatzfelder[]|null
     */
    public function getIndiv_zusatzfelder()
    {
        return $this->{'indiv-zusatzfelder'};
    }
    /**
     * This method is responsible for validating the values passed to the setIndiv_zusatzfelder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIndiv_zusatzfelder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIndiv_zusatzfelderForArrayConstraintsFromSetIndiv_zusatzfelder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cMsIndiv_zusatzfelderItem) {
            // validation for constraint: itemType
            if (!$cMsIndiv_zusatzfelderItem instanceof \booking-assistent\StructType\CIndivZusatzfelder) {
                $invalidValues[] = is_object($cMsIndiv_zusatzfelderItem) ? get_class($cMsIndiv_zusatzfelderItem) : sprintf('%s(%s)', gettype($cMsIndiv_zusatzfelderItem), var_export($cMsIndiv_zusatzfelderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The indiv_zusatzfelder property can only contain items of type \booking-assistent\StructType\CIndivZusatzfelder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set indiv_zusatzfelder value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CIndivZusatzfelder[] $indiv_zusatzfelder
     * @return \booking-assistent\StructType\CMs
     */
    public function setIndiv_zusatzfelder(array $indiv_zusatzfelder = array())
    {
        // validation for constraint: array
        if ('' !== ($indiv_zusatzfelderArrayErrorMessage = self::validateIndiv_zusatzfelderForArrayConstraintsFromSetIndiv_zusatzfelder($indiv_zusatzfelder))) {
            throw new \InvalidArgumentException($indiv_zusatzfelderArrayErrorMessage, __LINE__);
        }
        $this->indiv_zusatzfelder = $this->{'indiv-zusatzfelder'} = $indiv_zusatzfelder;
        return $this;
    }
    /**
     * Add item to indiv_zusatzfelder value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CIndivZusatzfelder $item
     * @return \booking-assistent\StructType\CMs
     */
    public function addToIndiv_zusatzfelder(\booking-assistent\StructType\CIndivZusatzfelder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CIndivZusatzfelder) {
            throw new \InvalidArgumentException(sprintf('The indiv_zusatzfelder property can only contain items of type \booking-assistent\StructType\CIndivZusatzfelder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->indiv_zusatzfelder[] = $this->{'indiv-zusatzfelder'}[] = $item;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \booking-assistent\StructType\CMs
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get digit_gastkart value
     * @return bool|null
     */
    public function getDigit_gastkart()
    {
        return $this->digit_gastkart;
    }
    /**
     * Set digit_gastkart value
     * @param bool $digit_gastkart
     * @return \booking-assistent\StructType\CMs
     */
    public function setDigit_gastkart($digit_gastkart = null)
    {
        // validation for constraint: boolean
        if (!is_null($digit_gastkart) && !is_bool($digit_gastkart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($digit_gastkart, true), gettype($digit_gastkart)), __LINE__);
        }
        $this->digit_gastkart = $digit_gastkart;
        return $this;
    }
    /**
     * Get ue_e_gelt value
     * @return float|null
     */
    public function getUe_e_gelt()
    {
        return $this->{'ue-e-gelt'};
    }
    /**
     * Set ue_e_gelt value
     * @param float $ue_e_gelt
     * @return \booking-assistent\StructType\CMs
     */
    public function setUe_e_gelt($ue_e_gelt = null)
    {
        // validation for constraint: float
        if (!is_null($ue_e_gelt) && !(is_float($ue_e_gelt) || is_numeric($ue_e_gelt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ue_e_gelt, true), gettype($ue_e_gelt)), __LINE__);
        }
        $this->ue_e_gelt = $this->{'ue-e-gelt'} = $ue_e_gelt;
        return $this;
    }
    /**
     * Get authentifizierung value
     * @return string|null
     */
    public function getAuthentifizierung()
    {
        return $this->authentifizierung;
    }
    /**
     * Set authentifizierung value
     * @param string $authentifizierung
     * @return \booking-assistent\StructType\CMs
     */
    public function setAuthentifizierung($authentifizierung = null)
    {
        // validation for constraint: string
        if (!is_null($authentifizierung) && !is_string($authentifizierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authentifizierung, true), gettype($authentifizierung)), __LINE__);
        }
        $this->authentifizierung = $authentifizierung;
        return $this;
    }
    /**
     * Get weitere_kosten value
     * @return float|null
     */
    public function getWeitere_kosten()
    {
        return $this->weitere_kosten;
    }
    /**
     * Set weitere_kosten value
     * @param float $weitere_kosten
     * @return \booking-assistent\StructType\CMs
     */
    public function setWeitere_kosten($weitere_kosten = null)
    {
        // validation for constraint: float
        if (!is_null($weitere_kosten) && !(is_float($weitere_kosten) || is_numeric($weitere_kosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weitere_kosten, true), gettype($weitere_kosten)), __LINE__);
        }
        $this->weitere_kosten = $weitere_kosten;
        return $this;
    }
    /**
     * Get begleitperson value
     * @return \booking-assistent\StructType\CBegleitperson[]|null
     */
    public function getBegleitperson()
    {
        return isset($this->begleitperson) ? $this->begleitperson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBegleitpersonForArrayConstraintsFromSetBegleitperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cMsBegleitpersonItem) {
            // validation for constraint: itemType
            if (!$cMsBegleitpersonItem instanceof \booking-assistent\StructType\CBegleitperson) {
                $invalidValues[] = is_object($cMsBegleitpersonItem) ? get_class($cMsBegleitpersonItem) : sprintf('%s(%s)', gettype($cMsBegleitpersonItem), var_export($cMsBegleitpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The begleitperson property can only contain items of type \booking-assistent\StructType\CBegleitperson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBegleitpersonForChoiceConstraintsFromSetBegleitperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitgruppe',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitperson can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set begleitperson value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitperson[] $begleitperson
     * @return \booking-assistent\StructType\CMs
     */
    public function setBegleitperson(array $begleitperson = array())
    {
        // validation for constraint: array
        if ('' !== ($begleitpersonArrayErrorMessage = self::validateBegleitpersonForArrayConstraintsFromSetBegleitperson($begleitperson))) {
            throw new \InvalidArgumentException($begleitpersonArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($begleitpersonChoiceErrorMessage = self::validateBegleitpersonForChoiceConstraintsFromSetBegleitperson($begleitperson))) {
            throw new \InvalidArgumentException($begleitpersonChoiceErrorMessage, __LINE__);
        }
        if (is_null($begleitperson) || (is_array($begleitperson) && empty($begleitperson))) {
            unset($this->begleitperson);
        } else {
            $this->begleitperson = $begleitperson;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBegleitperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBegleitperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitgruppe',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitperson can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to begleitperson value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitperson $item
     * @return \booking-assistent\StructType\CMs
     */
    public function addToBegleitperson(\booking-assistent\StructType\CBegleitperson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CBegleitperson) {
            throw new \InvalidArgumentException(sprintf('The begleitperson property can only contain items of type \booking-assistent\StructType\CBegleitperson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBegleitperson($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->begleitperson[] = $item;
        return $this;
    }
    /**
     * Get begleitgruppe value
     * @return \booking-assistent\StructType\CBegleitgruppe[]|null
     */
    public function getBegleitgruppe()
    {
        return isset($this->begleitgruppe) ? $this->begleitgruppe : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitgruppe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBegleitgruppeForArrayConstraintsFromSetBegleitgruppe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cMsBegleitgruppeItem) {
            // validation for constraint: itemType
            if (!$cMsBegleitgruppeItem instanceof \booking-assistent\StructType\CBegleitgruppe) {
                $invalidValues[] = is_object($cMsBegleitgruppeItem) ? get_class($cMsBegleitgruppeItem) : sprintf('%s(%s)', gettype($cMsBegleitgruppeItem), var_export($cMsBegleitgruppeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The begleitgruppe property can only contain items of type \booking-assistent\StructType\CBegleitgruppe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitgruppe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBegleitgruppeForChoiceConstraintsFromSetBegleitgruppe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitgruppe can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitgruppe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set begleitgruppe value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitgruppe[] $begleitgruppe
     * @return \booking-assistent\StructType\CMs
     */
    public function setBegleitgruppe(array $begleitgruppe = array())
    {
        // validation for constraint: array
        if ('' !== ($begleitgruppeArrayErrorMessage = self::validateBegleitgruppeForArrayConstraintsFromSetBegleitgruppe($begleitgruppe))) {
            throw new \InvalidArgumentException($begleitgruppeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($begleitgruppeChoiceErrorMessage = self::validateBegleitgruppeForChoiceConstraintsFromSetBegleitgruppe($begleitgruppe))) {
            throw new \InvalidArgumentException($begleitgruppeChoiceErrorMessage, __LINE__);
        }
        if (is_null($begleitgruppe) || (is_array($begleitgruppe) && empty($begleitgruppe))) {
            unset($this->begleitgruppe);
        } else {
            $this->begleitgruppe = $begleitgruppe;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBegleitgruppe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBegleitgruppe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitgruppe can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitgruppe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to begleitgruppe value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitgruppe $item
     * @return \booking-assistent\StructType\CMs
     */
    public function addToBegleitgruppe(\booking-assistent\StructType\CBegleitgruppe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CBegleitgruppe) {
            throw new \InvalidArgumentException(sprintf('The begleitgruppe property can only contain items of type \booking-assistent\StructType\CBegleitgruppe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBegleitgruppe($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->begleitgruppe[] = $item;
        return $this;
    }
}
