<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cLand StructType
 * @subpackage Structs
 */
class CLand extends AbstractStructBase
{
    /**
     * The land_id
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $land_id;
    /**
     * The land_iso
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $land_iso;
    /**
     * Constructor method for cLand
     * @uses CLand::setLand_id()
     * @uses CLand::setLand_iso()
     * @param int $land_id
     * @param string $land_iso
     */
    public function __construct($land_id = null, $land_iso = null)
    {
        $this
            ->setLand_id($land_id)
            ->setLand_iso($land_iso);
    }
    /**
     * Get land_id value
     * @return int|null
     */
    public function getLand_id()
    {
        return $this->{'land-id'};
    }
    /**
     * Set land_id value
     * @param int $land_id
     * @return \booking-assistent\StructType\CLand
     */
    public function setLand_id($land_id = null)
    {
        // validation for constraint: int
        if (!is_null($land_id) && !(is_int($land_id) || ctype_digit($land_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($land_id, true), gettype($land_id)), __LINE__);
        }
        $this->land_id = $this->{'land-id'} = $land_id;
        return $this;
    }
    /**
     * Get land_iso value
     * @return string|null
     */
    public function getLand_iso()
    {
        return $this->{'land-iso'};
    }
    /**
     * Set land_iso value
     * @param string $land_iso
     * @return \booking-assistent\StructType\CLand
     */
    public function setLand_iso($land_iso = null)
    {
        // validation for constraint: string
        if (!is_null($land_iso) && !is_string($land_iso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($land_iso, true), gettype($land_iso)), __LINE__);
        }
        $this->land_iso = $this->{'land-iso'} = $land_iso;
        return $this;
    }
}
