<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBenutzer StructType
 * @subpackage Structs
 */
class CBenutzer extends AbstractStructBase
{
    /**
     * The firmenbetriebsnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $firmenbetriebsnummer;
    /**
     * The anwenderkz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $anwenderkz;
    /**
     * The benutzerid
     * @var int
     */
    public $benutzerid;
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * @var string
     */
    public $kennung;
    /**
     * The passwort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * @var string
     */
    public $passwort;
    /**
     * Constructor method for cBenutzer
     * @uses CBenutzer::setFirmenbetriebsnummer()
     * @uses CBenutzer::setAnwenderkz()
     * @uses CBenutzer::setBenutzerid()
     * @uses CBenutzer::setKennung()
     * @uses CBenutzer::setPasswort()
     * @param string $firmenbetriebsnummer
     * @param string $anwenderkz
     * @param int $benutzerid
     * @param string $kennung
     * @param string $passwort
     */
    public function __construct($firmenbetriebsnummer = null, $anwenderkz = null, $benutzerid = null, $kennung = null, $passwort = null)
    {
        $this
            ->setFirmenbetriebsnummer($firmenbetriebsnummer)
            ->setAnwenderkz($anwenderkz)
            ->setBenutzerid($benutzerid)
            ->setKennung($kennung)
            ->setPasswort($passwort);
    }
    /**
     * Get firmenbetriebsnummer value
     * @return string
     */
    public function getFirmenbetriebsnummer()
    {
        return $this->firmenbetriebsnummer;
    }
    /**
     * Set firmenbetriebsnummer value
     * @param string $firmenbetriebsnummer
     * @return \booking-assistent\StructType\CBenutzer
     */
    public function setFirmenbetriebsnummer($firmenbetriebsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($firmenbetriebsnummer) && !is_string($firmenbetriebsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmenbetriebsnummer, true), gettype($firmenbetriebsnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($firmenbetriebsnummer) && mb_strlen($firmenbetriebsnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($firmenbetriebsnummer)), __LINE__);
        }
        $this->firmenbetriebsnummer = $firmenbetriebsnummer;
        return $this;
    }
    /**
     * Get anwenderkz value
     * @return string
     */
    public function getAnwenderkz()
    {
        return $this->anwenderkz;
    }
    /**
     * Set anwenderkz value
     * @uses \booking-assistent\EnumType\SAnwenderKz::valueIsValid()
     * @uses \booking-assistent\EnumType\SAnwenderKz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anwenderkz
     * @return \booking-assistent\StructType\CBenutzer
     */
    public function setAnwenderkz($anwenderkz = null)
    {
        // validation for constraint: enumeration
        if (!\booking-assistent\EnumType\SAnwenderKz::valueIsValid($anwenderkz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \booking-assistent\EnumType\SAnwenderKz', is_array($anwenderkz) ? implode(', ', $anwenderkz) : var_export($anwenderkz, true), implode(', ', \booking-assistent\EnumType\SAnwenderKz::getValidValues())), __LINE__);
        }
        $this->anwenderkz = $anwenderkz;
        return $this;
    }
    /**
     * Get benutzerid value
     * @return int|null
     */
    public function getBenutzerid()
    {
        return $this->benutzerid;
    }
    /**
     * Set benutzerid value
     * @param int $benutzerid
     * @return \booking-assistent\StructType\CBenutzer
     */
    public function setBenutzerid($benutzerid = null)
    {
        // validation for constraint: int
        if (!is_null($benutzerid) && !(is_int($benutzerid) || ctype_digit($benutzerid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($benutzerid, true), gettype($benutzerid)), __LINE__);
        }
        $this->benutzerid = $benutzerid;
        return $this;
    }
    /**
     * Get kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \booking-assistent\StructType\CBenutzer
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get passwort value
     * @return string|null
     */
    public function getPasswort()
    {
        return $this->passwort;
    }
    /**
     * Set passwort value
     * @param string $passwort
     * @return \booking-assistent\StructType\CBenutzer
     */
    public function setPasswort($passwort = null)
    {
        // validation for constraint: string
        if (!is_null($passwort) && !is_string($passwort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwort, true), gettype($passwort)), __LINE__);
        }
        $this->passwort = $passwort;
        return $this;
    }
}
