<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBankverbindung StructType
 * @subpackage Structs
 */
class CBankverbindung extends AbstractStructBase
{
    /**
     * The zahlartid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxInclusive: 2
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $zahlartid;
    /**
     * The bankverbindung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minOccurs: 0
     * @var string
     */
    public $bankverbindung;
    /**
     * The kontonummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minOccurs: 0
     * - pattern: [0-9]*
     * @var string
     */
    public $kontonummer;
    /**
     * The bankleitzahl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minOccurs: 0
     * - pattern: [0-9]*
     * @var string
     */
    public $bankleitzahl;
    /**
     * The kontoinhaber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $kontoinhaber;
    /**
     * Constructor method for cBankverbindung
     * @uses CBankverbindung::setZahlartid()
     * @uses CBankverbindung::setBankverbindung()
     * @uses CBankverbindung::setKontonummer()
     * @uses CBankverbindung::setBankleitzahl()
     * @uses CBankverbindung::setKontoinhaber()
     * @param int $zahlartid
     * @param string $bankverbindung
     * @param string $kontonummer
     * @param string $bankleitzahl
     * @param string $kontoinhaber
     */
    public function __construct($zahlartid = null, $bankverbindung = null, $kontonummer = null, $bankleitzahl = null, $kontoinhaber = null)
    {
        $this
            ->setZahlartid($zahlartid)
            ->setBankverbindung($bankverbindung)
            ->setKontonummer($kontonummer)
            ->setBankleitzahl($bankleitzahl)
            ->setKontoinhaber($kontoinhaber);
    }
    /**
     * Get zahlartid value
     * @return int|null
     */
    public function getZahlartid()
    {
        return $this->zahlartid;
    }
    /**
     * Set zahlartid value
     * @param int $zahlartid
     * @return \booking-assistent\StructType\CBankverbindung
     */
    public function setZahlartid($zahlartid = null)
    {
        // validation for constraint: int
        if (!is_null($zahlartid) && !(is_int($zahlartid) || ctype_digit($zahlartid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zahlartid, true), gettype($zahlartid)), __LINE__);
        }
        // validation for constraint: maxInclusive(2)
        if (!is_null($zahlartid) && $zahlartid > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2', var_export($zahlartid, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($zahlartid) && $zahlartid < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($zahlartid, true)), __LINE__);
        }
        $this->zahlartid = $zahlartid;
        return $this;
    }
    /**
     * Get bankverbindung value
     * @return string|null
     */
    public function getBankverbindung()
    {
        return $this->bankverbindung;
    }
    /**
     * Set bankverbindung value
     * @param string $bankverbindung
     * @return \booking-assistent\StructType\CBankverbindung
     */
    public function setBankverbindung($bankverbindung = null)
    {
        // validation for constraint: string
        if (!is_null($bankverbindung) && !is_string($bankverbindung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankverbindung, true), gettype($bankverbindung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bankverbindung) && mb_strlen($bankverbindung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bankverbindung)), __LINE__);
        }
        $this->bankverbindung = $bankverbindung;
        return $this;
    }
    /**
     * Get kontonummer value
     * @return string|null
     */
    public function getKontonummer()
    {
        return $this->kontonummer;
    }
    /**
     * Set kontonummer value
     * @param string $kontonummer
     * @return \booking-assistent\StructType\CBankverbindung
     */
    public function setKontonummer($kontonummer = null)
    {
        // validation for constraint: string
        if (!is_null($kontonummer) && !is_string($kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontonummer, true), gettype($kontonummer)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($kontonummer)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*)
        if (!is_null($kontonummer) && !preg_match('/[0-9]*/', $kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*', var_export($kontonummer, true)), __LINE__);
        }
        $this->kontonummer = $kontonummer;
        return $this;
    }
    /**
     * Get bankleitzahl value
     * @return string|null
     */
    public function getBankleitzahl()
    {
        return $this->bankleitzahl;
    }
    /**
     * Set bankleitzahl value
     * @param string $bankleitzahl
     * @return \booking-assistent\StructType\CBankverbindung
     */
    public function setBankleitzahl($bankleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($bankleitzahl) && !is_string($bankleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankleitzahl, true), gettype($bankleitzahl)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bankleitzahl) && mb_strlen($bankleitzahl) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($bankleitzahl)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*)
        if (!is_null($bankleitzahl) && !preg_match('/[0-9]*/', $bankleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*', var_export($bankleitzahl, true)), __LINE__);
        }
        $this->bankleitzahl = $bankleitzahl;
        return $this;
    }
    /**
     * Get kontoinhaber value
     * @return string|null
     */
    public function getKontoinhaber()
    {
        return $this->kontoinhaber;
    }
    /**
     * Set kontoinhaber value
     * @param string $kontoinhaber
     * @return \booking-assistent\StructType\CBankverbindung
     */
    public function setKontoinhaber($kontoinhaber = null)
    {
        // validation for constraint: string
        if (!is_null($kontoinhaber) && !is_string($kontoinhaber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontoinhaber, true), gettype($kontoinhaber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($kontoinhaber) && mb_strlen($kontoinhaber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($kontoinhaber)), __LINE__);
        }
        $this->kontoinhaber = $kontoinhaber;
        return $this;
    }
}
