<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cAdresse StructType
 * @subpackage Structs
 */
class CAdresse extends AbstractStructBase
{
    /**
     * The adressartid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxInclusive: 5
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 1
     * @var int
     */
    public $adressartid;
    /**
     * The firmenadressname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minOccurs: 0
     * @var string
     */
    public $firmenadressname;
    /**
     * The anredeid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $anredeid;
    /**
     * The anrede
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $anrede;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $hausnummer;
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $ort;
    /**
     * The land
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CLand
     */
    public $land;
    /**
     * Constructor method for cAdresse
     * @uses CAdresse::setAdressartid()
     * @uses CAdresse::setFirmenadressname()
     * @uses CAdresse::setAnredeid()
     * @uses CAdresse::setAnrede()
     * @uses CAdresse::setTitel()
     * @uses CAdresse::setVorname()
     * @uses CAdresse::setName()
     * @uses CAdresse::setStrasse()
     * @uses CAdresse::setHausnummer()
     * @uses CAdresse::setPlz()
     * @uses CAdresse::setOrt()
     * @uses CAdresse::setLand()
     * @param int $adressartid
     * @param string $firmenadressname
     * @param int $anredeid
     * @param string $anrede
     * @param string $titel
     * @param string $vorname
     * @param string $name
     * @param string $strasse
     * @param string $hausnummer
     * @param string $plz
     * @param string $ort
     * @param \booking-assistent\StructType\CLand $land
     */
    public function __construct($adressartid = null, $firmenadressname = null, $anredeid = null, $anrede = null, $titel = null, $vorname = null, $name = null, $strasse = null, $hausnummer = null, $plz = null, $ort = null, \booking-assistent\StructType\CLand $land = null)
    {
        $this
            ->setAdressartid($adressartid)
            ->setFirmenadressname($firmenadressname)
            ->setAnredeid($anredeid)
            ->setAnrede($anrede)
            ->setTitel($titel)
            ->setVorname($vorname)
            ->setName($name)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setLand($land);
    }
    /**
     * Get adressartid value
     * @return int
     */
    public function getAdressartid()
    {
        return $this->adressartid;
    }
    /**
     * Set adressartid value
     * @param int $adressartid
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setAdressartid($adressartid = null)
    {
        // validation for constraint: int
        if (!is_null($adressartid) && !(is_int($adressartid) || ctype_digit($adressartid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adressartid, true), gettype($adressartid)), __LINE__);
        }
        // validation for constraint: maxInclusive(5)
        if (!is_null($adressartid) && $adressartid > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 5', var_export($adressartid, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($adressartid) && $adressartid < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($adressartid, true)), __LINE__);
        }
        $this->adressartid = $adressartid;
        return $this;
    }
    /**
     * Get firmenadressname value
     * @return string|null
     */
    public function getFirmenadressname()
    {
        return $this->firmenadressname;
    }
    /**
     * Set firmenadressname value
     * @param string $firmenadressname
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setFirmenadressname($firmenadressname = null)
    {
        // validation for constraint: string
        if (!is_null($firmenadressname) && !is_string($firmenadressname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmenadressname, true), gettype($firmenadressname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($firmenadressname) && mb_strlen($firmenadressname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($firmenadressname)), __LINE__);
        }
        $this->firmenadressname = $firmenadressname;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @uses \booking-assistent\EnumType\SAnrede::valueIsValid()
     * @uses \booking-assistent\EnumType\SAnrede::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\booking-assistent\EnumType\SAnrede::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \booking-assistent\EnumType\SAnrede', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \booking-assistent\EnumType\SAnrede::getValidValues())), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @uses \booking-assistent\EnumType\STitel::valueIsValid()
     * @uses \booking-assistent\EnumType\STitel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $titel
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: enumeration
        if (!\booking-assistent\EnumType\STitel::valueIsValid($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \booking-assistent\EnumType\STitel', is_array($titel) ? implode(', ', $titel) : var_export($titel, true), implode(', ', \booking-assistent\EnumType\STitel::getValidValues())), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($strasse) && mb_strlen($strasse) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($plz) && mb_strlen($plz) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ort) && mb_strlen($ort) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get land value
     * @return \booking-assistent\StructType\CLand|null
     */
    public function getLand()
    {
        return $this->land;
    }
    /**
     * Set land value
     * @param \booking-assistent\StructType\CLand $land
     * @return \booking-assistent\StructType\CAdresse
     */
    public function setLand(\booking-assistent\StructType\CLand $land = null)
    {
        $this->land = $land;
        return $this;
    }
}
