<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cParameter StructType
 * @subpackage Structs
 */
class CParameter extends AbstractStructBase
{
    /**
     * The param
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $param;
    /**
     * Constructor method for cParameter
     * @uses CParameter::setParam()
     * @param string[] $param
     */
    public function __construct(array $param = array())
    {
        $this
            ->setParam($param);
    }
    /**
     * Get param value
     * @return string[]
     */
    public function getParam()
    {
        return $this->param;
    }
    /**
     * This method is responsible for validating the values passed to the setParam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamForArrayConstraintsFromSetParam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cParameterParamItem) {
            // validation for constraint: itemType
            if (!is_string($cParameterParamItem)) {
                $invalidValues[] = is_object($cParameterParamItem) ? get_class($cParameterParamItem) : sprintf('%s(%s)', gettype($cParameterParamItem), var_export($cParameterParamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The param property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set param value
     * @throws \InvalidArgumentException
     * @param string[] $param
     * @return \booking-assistent\StructType\CParameter
     */
    public function setParam(array $param = array())
    {
        // validation for constraint: array
        if ('' !== ($paramArrayErrorMessage = self::validateParamForArrayConstraintsFromSetParam($param))) {
            throw new \InvalidArgumentException($paramArrayErrorMessage, __LINE__);
        }
        $this->param = $param;
        return $this;
    }
    /**
     * Add item to param value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \booking-assistent\StructType\CParameter
     */
    public function addToParam($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The param property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->param[] = $item;
        return $this;
    }
}
