<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBegleitperson StructType
 * @subpackage Structs
 */
class CBegleitperson extends AbstractStructBase
{
    /**
     * The personid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $personid;
    /**
     * The anredeid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $anredeid;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $geburtsdatum;
    /**
     * The kategorieid
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $kategorieid;
    /**
     * The anreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $anreise;
    /**
     * The abreise
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - minOccurs: 0
     * @var string
     */
    public $abreise;
    /**
     * The staatsangehoerigkeitid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $staatsangehoerigkeitid;
    /**
     * The staatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CLand
     */
    public $staatsangehoerigkeit;
    /**
     * The ausweisnr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ausweisnr;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $betrag;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The digit_gastkart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $digit_gastkart;
    /**
     * Constructor method for cBegleitperson
     * @uses CBegleitperson::setPersonid()
     * @uses CBegleitperson::setAnredeid()
     * @uses CBegleitperson::setName()
     * @uses CBegleitperson::setVorname()
     * @uses CBegleitperson::setGeburtsdatum()
     * @uses CBegleitperson::setKategorieid()
     * @uses CBegleitperson::setAnreise()
     * @uses CBegleitperson::setAbreise()
     * @uses CBegleitperson::setStaatsangehoerigkeitid()
     * @uses CBegleitperson::setStaatsangehoerigkeit()
     * @uses CBegleitperson::setAusweisnr()
     * @uses CBegleitperson::setBarcode()
     * @uses CBegleitperson::setBetrag()
     * @uses CBegleitperson::setEmail()
     * @uses CBegleitperson::setDigit_gastkart()
     * @param int $personid
     * @param int $anredeid
     * @param string $name
     * @param string $vorname
     * @param string $geburtsdatum
     * @param int $kategorieid
     * @param string $anreise
     * @param string $abreise
     * @param int $staatsangehoerigkeitid
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeit
     * @param string $ausweisnr
     * @param string $barcode
     * @param float $betrag
     * @param string $email
     * @param bool $digit_gastkart
     */
    public function __construct($personid = null, $anredeid = null, $name = null, $vorname = null, $geburtsdatum = null, $kategorieid = null, $anreise = null, $abreise = null, $staatsangehoerigkeitid = null, \booking-assistent\StructType\CLand $staatsangehoerigkeit = null, $ausweisnr = null, $barcode = null, $betrag = null, $email = null, $digit_gastkart = null)
    {
        $this
            ->setPersonid($personid)
            ->setAnredeid($anredeid)
            ->setName($name)
            ->setVorname($vorname)
            ->setGeburtsdatum($geburtsdatum)
            ->setKategorieid($kategorieid)
            ->setAnreise($anreise)
            ->setAbreise($abreise)
            ->setStaatsangehoerigkeitid($staatsangehoerigkeitid)
            ->setStaatsangehoerigkeit($staatsangehoerigkeit)
            ->setAusweisnr($ausweisnr)
            ->setBarcode($barcode)
            ->setBetrag($betrag)
            ->setEmail($email)
            ->setDigit_gastkart($digit_gastkart);
    }
    /**
     * Get personid value
     * @return int|null
     */
    public function getPersonid()
    {
        return $this->personid;
    }
    /**
     * Set personid value
     * @param int $personid
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setPersonid($personid = null)
    {
        // validation for constraint: int
        if (!is_null($personid) && !(is_int($personid) || ctype_digit($personid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personid, true), gettype($personid)), __LINE__);
        }
        $this->personid = $personid;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * Set kategorieid value
     * @param int $kategorieid
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setKategorieid($kategorieid = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid) && !(is_int($kategorieid) || ctype_digit($kategorieid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid, true), gettype($kategorieid)), __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Get anreise value
     * @return string|null
     */
    public function getAnreise()
    {
        return $this->anreise;
    }
    /**
     * Set anreise value
     * @param string $anreise
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setAnreise($anreise = null)
    {
        // validation for constraint: string
        if (!is_null($anreise) && !is_string($anreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anreise, true), gettype($anreise)), __LINE__);
        }
        $this->anreise = $anreise;
        return $this;
    }
    /**
     * Get abreise value
     * @return string|null
     */
    public function getAbreise()
    {
        return $this->abreise;
    }
    /**
     * Set abreise value
     * @param string $abreise
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setAbreise($abreise = null)
    {
        // validation for constraint: string
        if (!is_null($abreise) && !is_string($abreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abreise, true), gettype($abreise)), __LINE__);
        }
        $this->abreise = $abreise;
        return $this;
    }
    /**
     * Get staatsangehoerigkeitid value
     * @return int|null
     */
    public function getStaatsangehoerigkeitid()
    {
        return $this->staatsangehoerigkeitid;
    }
    /**
     * Set staatsangehoerigkeitid value
     * @param int $staatsangehoerigkeitid
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setStaatsangehoerigkeitid($staatsangehoerigkeitid = null)
    {
        // validation for constraint: int
        if (!is_null($staatsangehoerigkeitid) && !(is_int($staatsangehoerigkeitid) || ctype_digit($staatsangehoerigkeitid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staatsangehoerigkeitid, true), gettype($staatsangehoerigkeitid)), __LINE__);
        }
        $this->staatsangehoerigkeitid = $staatsangehoerigkeitid;
        return $this;
    }
    /**
     * Get staatsangehoerigkeit value
     * @return \booking-assistent\StructType\CLand|null
     */
    public function getStaatsangehoerigkeit()
    {
        return $this->staatsangehoerigkeit;
    }
    /**
     * Set staatsangehoerigkeit value
     * @param \booking-assistent\StructType\CLand $staatsangehoerigkeit
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setStaatsangehoerigkeit(\booking-assistent\StructType\CLand $staatsangehoerigkeit = null)
    {
        $this->staatsangehoerigkeit = $staatsangehoerigkeit;
        return $this;
    }
    /**
     * Get ausweisnr value
     * @return string|null
     */
    public function getAusweisnr()
    {
        return $this->ausweisnr;
    }
    /**
     * Set ausweisnr value
     * @param string $ausweisnr
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setAusweisnr($ausweisnr = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnr) && !is_string($ausweisnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnr, true), gettype($ausweisnr)), __LINE__);
        }
        $this->ausweisnr = $ausweisnr;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    /**
     * Set betrag value
     * @param float $betrag
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        $this->betrag = $betrag;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get digit_gastkart value
     * @return bool|null
     */
    public function getDigit_gastkart()
    {
        return $this->digit_gastkart;
    }
    /**
     * Set digit_gastkart value
     * @param bool $digit_gastkart
     * @return \booking-assistent\StructType\CBegleitperson
     */
    public function setDigit_gastkart($digit_gastkart = null)
    {
        // validation for constraint: boolean
        if (!is_null($digit_gastkart) && !is_bool($digit_gastkart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($digit_gastkart, true), gettype($digit_gastkart)), __LINE__);
        }
        $this->digit_gastkart = $digit_gastkart;
        return $this;
    }
}
