<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBegleitgruppe StructType
 * @subpackage Structs
 */
class CBegleitgruppe extends AbstractStructBase
{
    /**
     * The personid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $personid;
    /**
     * The kategorieid
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $kategorieid;
    /**
     * The anzahl
     * @var int
     */
    public $anzahl;
    /**
     * The betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $betrag;
    /**
     * The ausweisnr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ausweisnr;
    /**
     * Constructor method for cBegleitgruppe
     * @uses CBegleitgruppe::setPersonid()
     * @uses CBegleitgruppe::setKategorieid()
     * @uses CBegleitgruppe::setAnzahl()
     * @uses CBegleitgruppe::setBetrag()
     * @uses CBegleitgruppe::setAusweisnr()
     * @param int $personid
     * @param int $kategorieid
     * @param int $anzahl
     * @param float $betrag
     * @param string $ausweisnr
     */
    public function __construct($personid = null, $kategorieid = null, $anzahl = null, $betrag = null, $ausweisnr = null)
    {
        $this
            ->setPersonid($personid)
            ->setKategorieid($kategorieid)
            ->setAnzahl($anzahl)
            ->setBetrag($betrag)
            ->setAusweisnr($ausweisnr);
    }
    /**
     * Get personid value
     * @return int|null
     */
    public function getPersonid()
    {
        return $this->personid;
    }
    /**
     * Set personid value
     * @param int $personid
     * @return \booking-assistent\StructType\CBegleitgruppe
     */
    public function setPersonid($personid = null)
    {
        // validation for constraint: int
        if (!is_null($personid) && !(is_int($personid) || ctype_digit($personid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personid, true), gettype($personid)), __LINE__);
        }
        $this->personid = $personid;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * Set kategorieid value
     * @param int $kategorieid
     * @return \booking-assistent\StructType\CBegleitgruppe
     */
    public function setKategorieid($kategorieid = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid) && !(is_int($kategorieid) || ctype_digit($kategorieid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid, true), gettype($kategorieid)), __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Get anzahl value
     * @return int|null
     */
    public function getAnzahl()
    {
        return $this->anzahl;
    }
    /**
     * Set anzahl value
     * @param int $anzahl
     * @return \booking-assistent\StructType\CBegleitgruppe
     */
    public function setAnzahl($anzahl = null)
    {
        // validation for constraint: int
        if (!is_null($anzahl) && !(is_int($anzahl) || ctype_digit($anzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahl, true), gettype($anzahl)), __LINE__);
        }
        $this->anzahl = $anzahl;
        return $this;
    }
    /**
     * Get betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    /**
     * Set betrag value
     * @param float $betrag
     * @return \booking-assistent\StructType\CBegleitgruppe
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        $this->betrag = $betrag;
        return $this;
    }
    /**
     * Get ausweisnr value
     * @return string|null
     */
    public function getAusweisnr()
    {
        return $this->ausweisnr;
    }
    /**
     * Set ausweisnr value
     * @param string $ausweisnr
     * @return \booking-assistent\StructType\CBegleitgruppe
     */
    public function setAusweisnr($ausweisnr = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnr) && !is_string($ausweisnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnr, true), gettype($ausweisnr)), __LINE__);
        }
        $this->ausweisnr = $ausweisnr;
        return $this;
    }
}
