<?php

namespace booking-assistent\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hole ServiceType
 * @subpackage Services
 */
class Hole extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named holeMeldeschein
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \booking-assistent\StructType\HoleMeldeschein $param0
     * @return \booking-assistent\StructType\HoleMeldeschein|bool
     */
    public function holeMeldeschein(\booking-assistent\StructType\HoleMeldeschein $param0)
    {
        try {
            $this->setResult($this->getSoapClient()->holeMeldeschein($param0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named holeMeldescheine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \booking-assistent\StructType\HoleMeldescheineRequest $param0
     * @return \booking-assistent\StructType\HoleMeldescheineResponse|bool
     */
    public function holeMeldescheine(\booking-assistent\StructType\HoleMeldescheineRequest $param0)
    {
        try {
            $this->setResult($this->getSoapClient()->holeMeldescheine($param0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \booking-assistent\StructType\HoleMeldeschein|\booking-assistent\StructType\HoleMeldescheineResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
