<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentChargesType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipShipmentChargesType extends AbstractStructBase
{
    /**
     * The RateChart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChart;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The TransportationCharges
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $TransportationCharges;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The ServiceOptionsCharges
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharges
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $TotalCharges;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $TotalChargesWithTaxes;
    /**
     * The EstimatedDutiesAndTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType
     */
    public $EstimatedDutiesAndTaxes;
    /**
     * Constructor method for ShipmentChargesType
     * @uses Ups_shipShipmentChargesType::setRateChart()
     * @uses Ups_shipShipmentChargesType::setBaseServiceCharge()
     * @uses Ups_shipShipmentChargesType::setTransportationCharges()
     * @uses Ups_shipShipmentChargesType::setItemizedCharges()
     * @uses Ups_shipShipmentChargesType::setServiceOptionsCharges()
     * @uses Ups_shipShipmentChargesType::setTaxCharges()
     * @uses Ups_shipShipmentChargesType::setTotalCharges()
     * @uses Ups_shipShipmentChargesType::setTotalChargesWithTaxes()
     * @uses Ups_shipShipmentChargesType::setEstimatedDutiesAndTaxes()
     * @param string $rateChart
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $transportationCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[] $itemizedCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType[] $taxCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalChargesWithTaxes
     * @param \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes
     */
    public function __construct($rateChart = null, \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge = null, \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $transportationCharges = null, array $itemizedCharges = array(), \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges = null, array $taxCharges = array(), \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalCharges = null, \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalChargesWithTaxes = null, \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes = null)
    {
        $this
            ->setRateChart($rateChart)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setTransportationCharges($transportationCharges)
            ->setItemizedCharges($itemizedCharges)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharges($totalCharges)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes)
            ->setEstimatedDutiesAndTaxes($estimatedDutiesAndTaxes);
    }
    /**
     * Get RateChart value
     * @return string|null
     */
    public function getRateChart()
    {
        return $this->RateChart;
    }
    /**
     * Set RateChart value
     * @param string $rateChart
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setRateChart($rateChart = null)
    {
        // validation for constraint: string
        if (!is_null($rateChart) && !is_string($rateChart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChart, true), gettype($rateChart)), __LINE__);
        }
        $this->RateChart = $rateChart;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setBaseServiceCharge(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get TransportationCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $transportationCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setTransportationCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeItemizedChargesItem instanceof \Ups_ship\UPSshipStruct\Ups_shipShipChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeItemizedChargesItem) ? get_class($shipmentChargesTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeItemizedChargesItem), var_export($shipmentChargesTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[] $itemizedCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function addToItemizedCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setServiceOptionsCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeTaxChargesItem instanceof \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeTaxChargesItem) ? get_class($shipmentChargesTypeTaxChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeTaxChargesItem), var_export($shipmentChargesTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType[] $taxCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function addToTaxCharges(\Ups_ship\UPSshipStruct\Ups_shipTaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipTaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setTotalCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalChargesWithTaxes
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setTotalChargesWithTaxes(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
    /**
     * Get EstimatedDutiesAndTaxes value
     * @return \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType|null
     */
    public function getEstimatedDutiesAndTaxes()
    {
        return $this->EstimatedDutiesAndTaxes;
    }
    /**
     * Set EstimatedDutiesAndTaxes value
     * @param \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public function setEstimatedDutiesAndTaxes(\Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType $estimatedDutiesAndTaxes = null)
    {
        $this->EstimatedDutiesAndTaxes = $estimatedDutiesAndTaxes;
        return $this;
    }
}
