<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CODType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipCODType extends AbstractStructBase
{
    /**
     * The CODFundsCode
     * @var string
     */
    public $CODFundsCode;
    /**
     * The CODAmount
     * @var \Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType
     */
    public $CODAmount;
    /**
     * Constructor method for CODType
     * @uses Ups_shipCODType::setCODFundsCode()
     * @uses Ups_shipCODType::setCODAmount()
     * @param string $cODFundsCode
     * @param \Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType $cODAmount
     */
    public function __construct($cODFundsCode = null, \Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType $cODAmount = null)
    {
        $this
            ->setCODFundsCode($cODFundsCode)
            ->setCODAmount($cODAmount);
    }
    /**
     * Get CODFundsCode value
     * @return string|null
     */
    public function getCODFundsCode()
    {
        return $this->CODFundsCode;
    }
    /**
     * Set CODFundsCode value
     * @param string $cODFundsCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipCODType
     */
    public function setCODFundsCode($cODFundsCode = null)
    {
        // validation for constraint: string
        if (!is_null($cODFundsCode) && !is_string($cODFundsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODFundsCode, true), gettype($cODFundsCode)), __LINE__);
        }
        $this->CODFundsCode = $cODFundsCode;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return \Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param \Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType $cODAmount
     * @return \Ups_ship\UPSshipStruct\Ups_shipCODType
     */
    public function setCODAmount(\Ups_ship\UPSshipStruct\Ups_shipCurrencyMonetaryType $cODAmount = null)
    {
        $this->CODAmount = $cODAmount;
        return $this;
    }
}
