<?php

namespace Ups_ship\UPSshipService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPSshipService
 * @package Ups_ship
 * @subpackage Services
 */
class Ups_shipProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_ship\UPSshipStruct\Ups_shipUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_ship\UPSshipStruct\Ups_shipUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessShipment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_ship\UPSshipStruct\Ups_shipUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentRequest $body
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResponse|bool
     */
    public function ProcessShipment(\Ups_ship\UPSshipStruct\Ups_shipShipmentRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipConfirm
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_ship\UPSshipStruct\Ups_shipUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest $body
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipConfirmResponse|bool
     */
    public function ProcessShipConfirm(\Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipConfirm($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipAccept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_ship\UPSshipStruct\Ups_shipUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipAcceptRequest $body
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAcceptResponse|bool
     */
    public function ProcessShipAccept(\Ups_ship\UPSshipStruct\Ups_shipShipAcceptRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipAccept($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAcceptResponse|\Ups_ship\UPSshipStruct\Ups_shipShipConfirmResponse|\Ups_ship\UPSshipStruct\Ups_shipShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
