<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfoType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipPaymentInfoType extends AbstractStructBase
{
    /**
     * The ShipmentCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType[]
     */
    public $ShipmentCharge;
    /**
     * The SplitDutyVATIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SplitDutyVATIndicator;
    /**
     * Constructor method for PaymentInfoType
     * @uses Ups_shipPaymentInfoType::setShipmentCharge()
     * @uses Ups_shipPaymentInfoType::setSplitDutyVATIndicator()
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType[] $shipmentCharge
     * @param string $splitDutyVATIndicator
     */
    public function __construct(array $shipmentCharge = array(), $splitDutyVATIndicator = null)
    {
        $this
            ->setShipmentCharge($shipmentCharge)
            ->setSplitDutyVATIndicator($splitDutyVATIndicator);
    }
    /**
     * Get ShipmentCharge value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType[]|null
     */
    public function getShipmentCharge()
    {
        return $this->ShipmentCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentChargeForArrayConstraintsFromSetShipmentCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInfoTypeShipmentChargeItem) {
            // validation for constraint: itemType
            if (!$paymentInfoTypeShipmentChargeItem instanceof \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType) {
                $invalidValues[] = is_object($paymentInfoTypeShipmentChargeItem) ? get_class($paymentInfoTypeShipmentChargeItem) : sprintf('%s(%s)', gettype($paymentInfoTypeShipmentChargeItem), var_export($paymentInfoTypeShipmentChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentCharge property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentCharge value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType[] $shipmentCharge
     * @return \Ups_ship\UPSshipStruct\Ups_shipPaymentInfoType
     */
    public function setShipmentCharge(array $shipmentCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentChargeArrayErrorMessage = self::validateShipmentChargeForArrayConstraintsFromSetShipmentCharge($shipmentCharge))) {
            throw new \InvalidArgumentException($shipmentChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($shipmentCharge) && count($shipmentCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($shipmentCharge)), __LINE__);
        }
        $this->ShipmentCharge = $shipmentCharge;
        return $this;
    }
    /**
     * Add item to ShipmentCharge value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipPaymentInfoType
     */
    public function addToShipmentCharge(\Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentCharge property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipmentChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ShipmentCharge) && count($this->ShipmentCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ShipmentCharge)), __LINE__);
        }
        $this->ShipmentCharge[] = $item;
        return $this;
    }
    /**
     * Get SplitDutyVATIndicator value
     * @return string|null
     */
    public function getSplitDutyVATIndicator()
    {
        return $this->SplitDutyVATIndicator;
    }
    /**
     * Set SplitDutyVATIndicator value
     * @param string $splitDutyVATIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPaymentInfoType
     */
    public function setSplitDutyVATIndicator($splitDutyVATIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($splitDutyVATIndicator) && !is_string($splitDutyVATIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($splitDutyVATIndicator, true), gettype($splitDutyVATIndicator)), __LINE__);
        }
        $this->SplitDutyVATIndicator = $splitDutyVATIndicator;
        return $this;
    }
}
