<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageServiceOptionsType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipPackageServiceOptionsType extends AbstractStructBase
{
    /**
     * The DeliveryConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType
     */
    public $DeliveryConfirmation;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType
     */
    public $DeclaredValue;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPSOCODType
     */
    public $COD;
    /**
     * The AccessPointCOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType
     */
    public $AccessPointCOD;
    /**
     * The ShipperReleaseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperReleaseIndicator;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType
     */
    public $Notification;
    /**
     * The HazMat
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipHazMatType[]
     */
    public $HazMat;
    /**
     * The DryIce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipDryIceType
     */
    public $DryIce;
    /**
     * The UPSPremiumCareIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPSPremiumCareIndicator;
    /**
     * The ProactiveIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProactiveIndicator;
    /**
     * The PackageIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIdentifier;
    /**
     * The ClinicalTrialsID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClinicalTrialsID;
    /**
     * The RefrigerationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RefrigerationIndicator;
    /**
     * Constructor method for PackageServiceOptionsType
     * @uses Ups_shipPackageServiceOptionsType::setDeliveryConfirmation()
     * @uses Ups_shipPackageServiceOptionsType::setDeclaredValue()
     * @uses Ups_shipPackageServiceOptionsType::setCOD()
     * @uses Ups_shipPackageServiceOptionsType::setAccessPointCOD()
     * @uses Ups_shipPackageServiceOptionsType::setShipperReleaseIndicator()
     * @uses Ups_shipPackageServiceOptionsType::setNotification()
     * @uses Ups_shipPackageServiceOptionsType::setHazMat()
     * @uses Ups_shipPackageServiceOptionsType::setDryIce()
     * @uses Ups_shipPackageServiceOptionsType::setUPSPremiumCareIndicator()
     * @uses Ups_shipPackageServiceOptionsType::setProactiveIndicator()
     * @uses Ups_shipPackageServiceOptionsType::setPackageIdentifier()
     * @uses Ups_shipPackageServiceOptionsType::setClinicalTrialsID()
     * @uses Ups_shipPackageServiceOptionsType::setRefrigerationIndicator()
     * @param \Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType $deliveryConfirmation
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType $declaredValue
     * @param \Ups_ship\UPSshipStruct\Ups_shipPSOCODType $cOD
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType $accessPointCOD
     * @param string $shipperReleaseIndicator
     * @param \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType $notification
     * @param \Ups_ship\UPSshipStruct\Ups_shipHazMatType[] $hazMat
     * @param \Ups_ship\UPSshipStruct\Ups_shipDryIceType $dryIce
     * @param string $uPSPremiumCareIndicator
     * @param string $proactiveIndicator
     * @param string $packageIdentifier
     * @param string $clinicalTrialsID
     * @param string $refrigerationIndicator
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType $deliveryConfirmation = null, \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType $declaredValue = null, \Ups_ship\UPSshipStruct\Ups_shipPSOCODType $cOD = null, \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType $accessPointCOD = null, $shipperReleaseIndicator = null, \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType $notification = null, array $hazMat = array(), \Ups_ship\UPSshipStruct\Ups_shipDryIceType $dryIce = null, $uPSPremiumCareIndicator = null, $proactiveIndicator = null, $packageIdentifier = null, $clinicalTrialsID = null, $refrigerationIndicator = null)
    {
        $this
            ->setDeliveryConfirmation($deliveryConfirmation)
            ->setDeclaredValue($declaredValue)
            ->setCOD($cOD)
            ->setAccessPointCOD($accessPointCOD)
            ->setShipperReleaseIndicator($shipperReleaseIndicator)
            ->setNotification($notification)
            ->setHazMat($hazMat)
            ->setDryIce($dryIce)
            ->setUPSPremiumCareIndicator($uPSPremiumCareIndicator)
            ->setProactiveIndicator($proactiveIndicator)
            ->setPackageIdentifier($packageIdentifier)
            ->setClinicalTrialsID($clinicalTrialsID)
            ->setRefrigerationIndicator($refrigerationIndicator);
    }
    /**
     * Get DeliveryConfirmation value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType|null
     */
    public function getDeliveryConfirmation()
    {
        return $this->DeliveryConfirmation;
    }
    /**
     * Set DeliveryConfirmation value
     * @param \Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType $deliveryConfirmation
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setDeliveryConfirmation(\Ups_ship\UPSshipStruct\Ups_shipDeliveryConfirmationType $deliveryConfirmation = null)
    {
        $this->DeliveryConfirmation = $deliveryConfirmation;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType $declaredValue
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setDeclaredValue(\Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType $declaredValue = null)
    {
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get COD value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPSOCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPSOCODType $cOD
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setCOD(\Ups_ship\UPSshipStruct\Ups_shipPSOCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get AccessPointCOD value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType|null
     */
    public function getAccessPointCOD()
    {
        return $this->AccessPointCOD;
    }
    /**
     * Set AccessPointCOD value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType $accessPointCOD
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setAccessPointCOD(\Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsAccessPointCODType $accessPointCOD = null)
    {
        $this->AccessPointCOD = $accessPointCOD;
        return $this;
    }
    /**
     * Get ShipperReleaseIndicator value
     * @return string|null
     */
    public function getShipperReleaseIndicator()
    {
        return $this->ShipperReleaseIndicator;
    }
    /**
     * Set ShipperReleaseIndicator value
     * @param string $shipperReleaseIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setShipperReleaseIndicator($shipperReleaseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($shipperReleaseIndicator) && !is_string($shipperReleaseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperReleaseIndicator, true), gettype($shipperReleaseIndicator)), __LINE__);
        }
        $this->ShipperReleaseIndicator = $shipperReleaseIndicator;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType $notification
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setNotification(\Ups_ship\UPSshipStruct\Ups_shipPSONotificationType $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get HazMat value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHazMatType[]|null
     */
    public function getHazMat()
    {
        return $this->HazMat;
    }
    /**
     * This method is responsible for validating the values passed to the setHazMat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazMat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazMatForArrayConstraintsFromSetHazMat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageServiceOptionsTypeHazMatItem) {
            // validation for constraint: itemType
            if (!$packageServiceOptionsTypeHazMatItem instanceof \Ups_ship\UPSshipStruct\Ups_shipHazMatType) {
                $invalidValues[] = is_object($packageServiceOptionsTypeHazMatItem) ? get_class($packageServiceOptionsTypeHazMatItem) : sprintf('%s(%s)', gettype($packageServiceOptionsTypeHazMatItem), var_export($packageServiceOptionsTypeHazMatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazMat property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipHazMatType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazMat value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipHazMatType[] $hazMat
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setHazMat(array $hazMat = array())
    {
        // validation for constraint: array
        if ('' !== ($hazMatArrayErrorMessage = self::validateHazMatForArrayConstraintsFromSetHazMat($hazMat))) {
            throw new \InvalidArgumentException($hazMatArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($hazMat) && count($hazMat) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($hazMat)), __LINE__);
        }
        $this->HazMat = $hazMat;
        return $this;
    }
    /**
     * Add item to HazMat value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipHazMatType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function addToHazMat(\Ups_ship\UPSshipStruct\Ups_shipHazMatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipHazMatType) {
            throw new \InvalidArgumentException(sprintf('The HazMat property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipHazMatType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->HazMat) && count($this->HazMat) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->HazMat)), __LINE__);
        }
        $this->HazMat[] = $item;
        return $this;
    }
    /**
     * Get DryIce value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDryIceType|null
     */
    public function getDryIce()
    {
        return $this->DryIce;
    }
    /**
     * Set DryIce value
     * @param \Ups_ship\UPSshipStruct\Ups_shipDryIceType $dryIce
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setDryIce(\Ups_ship\UPSshipStruct\Ups_shipDryIceType $dryIce = null)
    {
        $this->DryIce = $dryIce;
        return $this;
    }
    /**
     * Get UPSPremiumCareIndicator value
     * @return string|null
     */
    public function getUPSPremiumCareIndicator()
    {
        return $this->UPSPremiumCareIndicator;
    }
    /**
     * Set UPSPremiumCareIndicator value
     * @param string $uPSPremiumCareIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setUPSPremiumCareIndicator($uPSPremiumCareIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($uPSPremiumCareIndicator) && !is_string($uPSPremiumCareIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPSPremiumCareIndicator, true), gettype($uPSPremiumCareIndicator)), __LINE__);
        }
        $this->UPSPremiumCareIndicator = $uPSPremiumCareIndicator;
        return $this;
    }
    /**
     * Get ProactiveIndicator value
     * @return string|null
     */
    public function getProactiveIndicator()
    {
        return $this->ProactiveIndicator;
    }
    /**
     * Set ProactiveIndicator value
     * @param string $proactiveIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setProactiveIndicator($proactiveIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($proactiveIndicator) && !is_string($proactiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proactiveIndicator, true), gettype($proactiveIndicator)), __LINE__);
        }
        $this->ProactiveIndicator = $proactiveIndicator;
        return $this;
    }
    /**
     * Get PackageIdentifier value
     * @return string|null
     */
    public function getPackageIdentifier()
    {
        return $this->PackageIdentifier;
    }
    /**
     * Set PackageIdentifier value
     * @param string $packageIdentifier
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setPackageIdentifier($packageIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($packageIdentifier) && !is_string($packageIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIdentifier, true), gettype($packageIdentifier)), __LINE__);
        }
        $this->PackageIdentifier = $packageIdentifier;
        return $this;
    }
    /**
     * Get ClinicalTrialsID value
     * @return string|null
     */
    public function getClinicalTrialsID()
    {
        return $this->ClinicalTrialsID;
    }
    /**
     * Set ClinicalTrialsID value
     * @param string $clinicalTrialsID
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setClinicalTrialsID($clinicalTrialsID = null)
    {
        // validation for constraint: string
        if (!is_null($clinicalTrialsID) && !is_string($clinicalTrialsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clinicalTrialsID, true), gettype($clinicalTrialsID)), __LINE__);
        }
        $this->ClinicalTrialsID = $clinicalTrialsID;
        return $this;
    }
    /**
     * Get RefrigerationIndicator value
     * @return string|null
     */
    public function getRefrigerationIndicator()
    {
        return $this->RefrigerationIndicator;
    }
    /**
     * Set RefrigerationIndicator value
     * @param string $refrigerationIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public function setRefrigerationIndicator($refrigerationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($refrigerationIndicator) && !is_string($refrigerationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refrigerationIndicator, true), gettype($refrigerationIndicator)), __LINE__);
        }
        $this->RefrigerationIndicator = $refrigerationIndicator;
        return $this;
    }
}
