<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageResultsType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipPackageResultsType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The ServiceOptionsCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The ShippingLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public $ShippingLabel;
    /**
     * The ShippingReceipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipReceiptType
     */
    public $ShippingReceipt;
    /**
     * The USPSPICNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USPSPICNumber;
    /**
     * The CN22Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22Number;
    /**
     * The Accessorial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipAccessorialType[]
     */
    public $Accessorial;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipFormType
     */
    public $Form;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The NegotiatedCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType
     */
    public $NegotiatedCharges;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipSimpleRateType
     */
    public $SimpleRate;
    /**
     * The SensorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SensorID;
    /**
     * The CommodityDutyCharges
     * @var mixed
     */
    public $CommodityDutyCharges;
    /**
     * Constructor method for PackageResultsType
     * @uses Ups_shipPackageResultsType::setTrackingNumber()
     * @uses Ups_shipPackageResultsType::setBaseServiceCharge()
     * @uses Ups_shipPackageResultsType::setServiceOptionsCharges()
     * @uses Ups_shipPackageResultsType::setShippingLabel()
     * @uses Ups_shipPackageResultsType::setShippingReceipt()
     * @uses Ups_shipPackageResultsType::setUSPSPICNumber()
     * @uses Ups_shipPackageResultsType::setCN22Number()
     * @uses Ups_shipPackageResultsType::setAccessorial()
     * @uses Ups_shipPackageResultsType::setForm()
     * @uses Ups_shipPackageResultsType::setItemizedCharges()
     * @uses Ups_shipPackageResultsType::setNegotiatedCharges()
     * @uses Ups_shipPackageResultsType::setSimpleRate()
     * @uses Ups_shipPackageResultsType::setSensorID()
     * @uses Ups_shipPackageResultsType::setCommodityDutyCharges()
     * @param string $trackingNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelType $shippingLabel
     * @param \Ups_ship\UPSshipStruct\Ups_shipReceiptType $shippingReceipt
     * @param string $uSPSPICNumber
     * @param string $cN22Number
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccessorialType[] $accessorial
     * @param \Ups_ship\UPSshipStruct\Ups_shipFormType $form
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[] $itemizedCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType $negotiatedCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipSimpleRateType $simpleRate
     * @param string $sensorID
     * @param mixed $commodityDutyCharges
     */
    public function __construct($trackingNumber = null, \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge = null, \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges = null, \Ups_ship\UPSshipStruct\Ups_shipLabelType $shippingLabel = null, \Ups_ship\UPSshipStruct\Ups_shipReceiptType $shippingReceipt = null, $uSPSPICNumber = null, $cN22Number = null, array $accessorial = array(), \Ups_ship\UPSshipStruct\Ups_shipFormType $form = null, array $itemizedCharges = array(), \Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType $negotiatedCharges = null, \Ups_ship\UPSshipStruct\Ups_shipSimpleRateType $simpleRate = null, $sensorID = null, $commodityDutyCharges = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setShippingLabel($shippingLabel)
            ->setShippingReceipt($shippingReceipt)
            ->setUSPSPICNumber($uSPSPICNumber)
            ->setCN22Number($cN22Number)
            ->setAccessorial($accessorial)
            ->setForm($form)
            ->setItemizedCharges($itemizedCharges)
            ->setNegotiatedCharges($negotiatedCharges)
            ->setSimpleRate($simpleRate)
            ->setSensorID($sensorID)
            ->setCommodityDutyCharges($commodityDutyCharges);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setBaseServiceCharge(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setServiceOptionsCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get ShippingLabel value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType|null
     */
    public function getShippingLabel()
    {
        return $this->ShippingLabel;
    }
    /**
     * Set ShippingLabel value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelType $shippingLabel
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setShippingLabel(\Ups_ship\UPSshipStruct\Ups_shipLabelType $shippingLabel = null)
    {
        $this->ShippingLabel = $shippingLabel;
        return $this;
    }
    /**
     * Get ShippingReceipt value
     * @return \Ups_ship\UPSshipStruct\Ups_shipReceiptType|null
     */
    public function getShippingReceipt()
    {
        return $this->ShippingReceipt;
    }
    /**
     * Set ShippingReceipt value
     * @param \Ups_ship\UPSshipStruct\Ups_shipReceiptType $shippingReceipt
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setShippingReceipt(\Ups_ship\UPSshipStruct\Ups_shipReceiptType $shippingReceipt = null)
    {
        $this->ShippingReceipt = $shippingReceipt;
        return $this;
    }
    /**
     * Get USPSPICNumber value
     * @return string|null
     */
    public function getUSPSPICNumber()
    {
        return $this->USPSPICNumber;
    }
    /**
     * Set USPSPICNumber value
     * @param string $uSPSPICNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setUSPSPICNumber($uSPSPICNumber = null)
    {
        // validation for constraint: string
        if (!is_null($uSPSPICNumber) && !is_string($uSPSPICNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSPSPICNumber, true), gettype($uSPSPICNumber)), __LINE__);
        }
        $this->USPSPICNumber = $uSPSPICNumber;
        return $this;
    }
    /**
     * Get CN22Number value
     * @return string|null
     */
    public function getCN22Number()
    {
        return $this->CN22Number;
    }
    /**
     * Set CN22Number value
     * @param string $cN22Number
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setCN22Number($cN22Number = null)
    {
        // validation for constraint: string
        if (!is_null($cN22Number) && !is_string($cN22Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22Number, true), gettype($cN22Number)), __LINE__);
        }
        $this->CN22Number = $cN22Number;
        return $this;
    }
    /**
     * Get Accessorial value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAccessorialType[]|null
     */
    public function getAccessorial()
    {
        return $this->Accessorial;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessorial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessorial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessorialForArrayConstraintsFromSetAccessorial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeAccessorialItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeAccessorialItem instanceof \Ups_ship\UPSshipStruct\Ups_shipAccessorialType) {
                $invalidValues[] = is_object($packageResultsTypeAccessorialItem) ? get_class($packageResultsTypeAccessorialItem) : sprintf('%s(%s)', gettype($packageResultsTypeAccessorialItem), var_export($packageResultsTypeAccessorialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accessorial property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipAccessorialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accessorial value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccessorialType[] $accessorial
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setAccessorial(array $accessorial = array())
    {
        // validation for constraint: array
        if ('' !== ($accessorialArrayErrorMessage = self::validateAccessorialForArrayConstraintsFromSetAccessorial($accessorial))) {
            throw new \InvalidArgumentException($accessorialArrayErrorMessage, __LINE__);
        }
        $this->Accessorial = $accessorial;
        return $this;
    }
    /**
     * Add item to Accessorial value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccessorialType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function addToAccessorial(\Ups_ship\UPSshipStruct\Ups_shipAccessorialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipAccessorialType) {
            throw new \InvalidArgumentException(sprintf('The Accessorial property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipAccessorialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accessorial[] = $item;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups_ship\UPSshipStruct\Ups_shipFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups_ship\UPSshipStruct\Ups_shipFormType $form
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setForm(\Ups_ship\UPSshipStruct\Ups_shipFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeItemizedChargesItem instanceof \Ups_ship\UPSshipStruct\Ups_shipShipChargeType) {
                $invalidValues[] = is_object($packageResultsTypeItemizedChargesItem) ? get_class($packageResultsTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($packageResultsTypeItemizedChargesItem), var_export($packageResultsTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType[] $itemizedCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipChargeType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function addToItemizedCharges(\Ups_ship\UPSshipStruct\Ups_shipShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get NegotiatedCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType|null
     */
    public function getNegotiatedCharges()
    {
        return $this->NegotiatedCharges;
    }
    /**
     * Set NegotiatedCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType $negotiatedCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setNegotiatedCharges(\Ups_ship\UPSshipStruct\Ups_shipNegotiatedChargesType $negotiatedCharges = null)
    {
        $this->NegotiatedCharges = $negotiatedCharges;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \Ups_ship\UPSshipStruct\Ups_shipSimpleRateType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \Ups_ship\UPSshipStruct\Ups_shipSimpleRateType $simpleRate
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setSimpleRate(\Ups_ship\UPSshipStruct\Ups_shipSimpleRateType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get SensorID value
     * @return string|null
     */
    public function getSensorID()
    {
        return $this->SensorID;
    }
    /**
     * Set SensorID value
     * @param string $sensorID
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setSensorID($sensorID = null)
    {
        // validation for constraint: string
        if (!is_null($sensorID) && !is_string($sensorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorID, true), gettype($sensorID)), __LINE__);
        }
        $this->SensorID = $sensorID;
        return $this;
    }
    /**
     * Get CommodityDutyCharges value
     * @return mixed|null
     */
    public function getCommodityDutyCharges()
    {
        return $this->CommodityDutyCharges;
    }
    /**
     * Set CommodityDutyCharges value
     * @param mixed $commodityDutyCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType
     */
    public function setCommodityDutyCharges($commodityDutyCharges = null)
    {
        $this->CommodityDutyCharges = $commodityDutyCharges;
        return $this;
    }
}
