<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipCompanyInfoType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The AttentionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttentionName;
    /**
     * The CompanyDisplayableName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyDisplayableName;
    /**
     * The TaxIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The TaxIDType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType
     */
    public $TaxIDType;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipPhoneType
     */
    public $Phone;
    /**
     * Constructor method for CompanyInfoType
     * @uses Ups_shipCompanyInfoType::setName()
     * @uses Ups_shipCompanyInfoType::setAttentionName()
     * @uses Ups_shipCompanyInfoType::setCompanyDisplayableName()
     * @uses Ups_shipCompanyInfoType::setTaxIdentificationNumber()
     * @uses Ups_shipCompanyInfoType::setTaxIDType()
     * @uses Ups_shipCompanyInfoType::setPhone()
     * @param string $name
     * @param string $attentionName
     * @param string $companyDisplayableName
     * @param string $taxIdentificationNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType $taxIDType
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipPhoneType $phone
     */
    public function __construct($name = null, $attentionName = null, $companyDisplayableName = null, $taxIdentificationNumber = null, \Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType $taxIDType = null, \Ups_ship\UPSshipStruct\Ups_shipShipPhoneType $phone = null)
    {
        $this
            ->setName($name)
            ->setAttentionName($attentionName)
            ->setCompanyDisplayableName($companyDisplayableName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setTaxIDType($taxIDType)
            ->setPhone($phone);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get CompanyDisplayableName value
     * @return string|null
     */
    public function getCompanyDisplayableName()
    {
        return $this->CompanyDisplayableName;
    }
    /**
     * Set CompanyDisplayableName value
     * @param string $companyDisplayableName
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setCompanyDisplayableName($companyDisplayableName = null)
    {
        // validation for constraint: string
        if (!is_null($companyDisplayableName) && !is_string($companyDisplayableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyDisplayableName, true), gettype($companyDisplayableName)), __LINE__);
        }
        $this->CompanyDisplayableName = $companyDisplayableName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get TaxIDType value
     * @return \Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType|null
     */
    public function getTaxIDType()
    {
        return $this->TaxIDType;
    }
    /**
     * Set TaxIDType value
     * @param \Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType $taxIDType
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setTaxIDType(\Ups_ship\UPSshipStruct\Ups_shipTaxIDCodeDescType $taxIDType = null)
    {
        $this->TaxIDType = $taxIDType;
        return $this;
    }
    /**
     * Get Phone value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipPhoneType|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipPhoneType $phone
     * @return \Ups_ship\UPSshipStruct\Ups_shipCompanyInfoType
     */
    public function setPhone(\Ups_ship\UPSshipStruct\Ups_shipShipPhoneType $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
}
