<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipFromType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipShipFromType extends Ups_shipCompanyInfoType
{
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipAddressType
     */
    public $Address;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The VendorInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipVendorInfoType
     */
    public $VendorInfo;
    /**
     * Constructor method for ShipFromType
     * @uses Ups_shipShipFromType::setFaxNumber()
     * @uses Ups_shipShipFromType::setAddress()
     * @uses Ups_shipShipFromType::setEMailAddress()
     * @uses Ups_shipShipFromType::setVendorInfo()
     * @param string $faxNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address
     * @param string $eMailAddress
     * @param \Ups_ship\UPSshipStruct\Ups_shipVendorInfoType $vendorInfo
     */
    public function __construct($faxNumber = null, \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address = null, $eMailAddress = null, \Ups_ship\UPSshipStruct\Ups_shipVendorInfoType $vendorInfo = null)
    {
        $this
            ->setFaxNumber($faxNumber)
            ->setAddress($address)
            ->setEMailAddress($eMailAddress)
            ->setVendorInfo($vendorInfo);
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipFromType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipFromType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipFromType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get VendorInfo value
     * @return \Ups_ship\UPSshipStruct\Ups_shipVendorInfoType|null
     */
    public function getVendorInfo()
    {
        return $this->VendorInfo;
    }
    /**
     * Set VendorInfo value
     * @param \Ups_ship\UPSshipStruct\Ups_shipVendorInfoType $vendorInfo
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipFromType
     */
    public function setVendorInfo(\Ups_ship\UPSshipStruct\Ups_shipVendorInfoType $vendorInfo = null)
    {
        $this->VendorInfo = $vendorInfo;
        return $this;
    }
}
