<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleBType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipScheduleBType extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $Quantity;
    /**
     * The UnitOfMeasurement
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType[]
     */
    public $UnitOfMeasurement;
    /**
     * Constructor method for ScheduleBType
     * @uses Ups_shipScheduleBType::setNumber()
     * @uses Ups_shipScheduleBType::setQuantity()
     * @uses Ups_shipScheduleBType::setUnitOfMeasurement()
     * @param string $number
     * @param string[] $quantity
     * @param \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType[] $unitOfMeasurement
     */
    public function __construct($number = null, array $quantity = array(), array $unitOfMeasurement = array())
    {
        $this
            ->setNumber($number)
            ->setQuantity($quantity)
            ->setUnitOfMeasurement($unitOfMeasurement);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Ups_ship\UPSshipStruct\Ups_shipScheduleBType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string[]|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityForArrayConstraintsFromSetQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $scheduleBTypeQuantityItem) {
            // validation for constraint: itemType
            if (!is_string($scheduleBTypeQuantityItem)) {
                $invalidValues[] = is_object($scheduleBTypeQuantityItem) ? get_class($scheduleBTypeQuantityItem) : sprintf('%s(%s)', gettype($scheduleBTypeQuantityItem), var_export($scheduleBTypeQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Quantity property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Quantity value
     * @throws \InvalidArgumentException
     * @param string[] $quantity
     * @return \Ups_ship\UPSshipStruct\Ups_shipScheduleBType
     */
    public function setQuantity(array $quantity = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityArrayErrorMessage = self::validateQuantityForArrayConstraintsFromSetQuantity($quantity))) {
            throw new \InvalidArgumentException($quantityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($quantity) && count($quantity) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Add item to Quantity value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipScheduleBType
     */
    public function addToQuantity($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Quantity property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Quantity) && count($this->Quantity) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Quantity)), __LINE__);
        }
        $this->Quantity[] = $item;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType[]|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitOfMeasurement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitOfMeasurement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitOfMeasurementForArrayConstraintsFromSetUnitOfMeasurement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $scheduleBTypeUnitOfMeasurementItem) {
            // validation for constraint: itemType
            if (!$scheduleBTypeUnitOfMeasurementItem instanceof \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType) {
                $invalidValues[] = is_object($scheduleBTypeUnitOfMeasurementItem) ? get_class($scheduleBTypeUnitOfMeasurementItem) : sprintf('%s(%s)', gettype($scheduleBTypeUnitOfMeasurementItem), var_export($scheduleBTypeUnitOfMeasurementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitOfMeasurement property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitOfMeasurement value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType[] $unitOfMeasurement
     * @return \Ups_ship\UPSshipStruct\Ups_shipScheduleBType
     */
    public function setUnitOfMeasurement(array $unitOfMeasurement = array())
    {
        // validation for constraint: array
        if ('' !== ($unitOfMeasurementArrayErrorMessage = self::validateUnitOfMeasurementForArrayConstraintsFromSetUnitOfMeasurement($unitOfMeasurement))) {
            throw new \InvalidArgumentException($unitOfMeasurementArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($unitOfMeasurement) && count($unitOfMeasurement) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($unitOfMeasurement)), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Add item to UnitOfMeasurement value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipScheduleBType
     */
    public function addToUnitOfMeasurement(\Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType) {
            throw new \InvalidArgumentException(sprintf('The UnitOfMeasurement property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->UnitOfMeasurement) && count($this->UnitOfMeasurement) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->UnitOfMeasurement)), __LINE__);
        }
        $this->UnitOfMeasurement[] = $item;
        return $this;
    }
}
