<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntermediateConsigneeType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipIntermediateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipAddressType
     */
    public $Address;
    /**
     * Constructor method for IntermediateConsigneeType
     * @uses Ups_shipIntermediateConsigneeType::setCompanyName()
     * @uses Ups_shipIntermediateConsigneeType::setAddress()
     * @param string $companyName
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     */
    public function __construct($companyName = null, \Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups_ship\UPSshipStruct\Ups_shipIntermediateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipIntermediateConsigneeType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
