<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailDetailsType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipEmailDetailsType extends AbstractStructBase
{
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $EMailAddress;
    /**
     * The UndeliverableEMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UndeliverableEMailAddress;
    /**
     * The FromEMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromEMailAddress;
    /**
     * The FromName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The SubjectCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubjectCode;
    /**
     * Constructor method for EmailDetailsType
     * @uses Ups_shipEmailDetailsType::setEMailAddress()
     * @uses Ups_shipEmailDetailsType::setUndeliverableEMailAddress()
     * @uses Ups_shipEmailDetailsType::setFromEMailAddress()
     * @uses Ups_shipEmailDetailsType::setFromName()
     * @uses Ups_shipEmailDetailsType::setMemo()
     * @uses Ups_shipEmailDetailsType::setSubject()
     * @uses Ups_shipEmailDetailsType::setSubjectCode()
     * @param string[] $eMailAddress
     * @param string $undeliverableEMailAddress
     * @param string $fromEMailAddress
     * @param string $fromName
     * @param string $memo
     * @param string $subject
     * @param string $subjectCode
     */
    public function __construct(array $eMailAddress = array(), $undeliverableEMailAddress = null, $fromEMailAddress = null, $fromName = null, $memo = null, $subject = null, $subjectCode = null)
    {
        $this
            ->setEMailAddress($eMailAddress)
            ->setUndeliverableEMailAddress($undeliverableEMailAddress)
            ->setFromEMailAddress($fromEMailAddress)
            ->setFromName($fromName)
            ->setMemo($memo)
            ->setSubject($subject)
            ->setSubjectCode($subjectCode);
    }
    /**
     * Get EMailAddress value
     * @return string[]|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEMailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEMailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEMailAddressForArrayConstraintsFromSetEMailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailDetailsTypeEMailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($emailDetailsTypeEMailAddressItem)) {
                $invalidValues[] = is_object($emailDetailsTypeEMailAddressItem) ? get_class($emailDetailsTypeEMailAddressItem) : sprintf('%s(%s)', gettype($emailDetailsTypeEMailAddressItem), var_export($emailDetailsTypeEMailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EMailAddress property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EMailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $eMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setEMailAddress(array $eMailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($eMailAddressArrayErrorMessage = self::validateEMailAddressForArrayConstraintsFromSetEMailAddress($eMailAddress))) {
            throw new \InvalidArgumentException($eMailAddressArrayErrorMessage, __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Add item to EMailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function addToEMailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EMailAddress property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EMailAddress[] = $item;
        return $this;
    }
    /**
     * Get UndeliverableEMailAddress value
     * @return string|null
     */
    public function getUndeliverableEMailAddress()
    {
        return $this->UndeliverableEMailAddress;
    }
    /**
     * Set UndeliverableEMailAddress value
     * @param string $undeliverableEMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setUndeliverableEMailAddress($undeliverableEMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($undeliverableEMailAddress) && !is_string($undeliverableEMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undeliverableEMailAddress, true), gettype($undeliverableEMailAddress)), __LINE__);
        }
        $this->UndeliverableEMailAddress = $undeliverableEMailAddress;
        return $this;
    }
    /**
     * Get FromEMailAddress value
     * @return string|null
     */
    public function getFromEMailAddress()
    {
        return $this->FromEMailAddress;
    }
    /**
     * Set FromEMailAddress value
     * @param string $fromEMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setFromEMailAddress($fromEMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromEMailAddress) && !is_string($fromEMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEMailAddress, true), gettype($fromEMailAddress)), __LINE__);
        }
        $this->FromEMailAddress = $fromEMailAddress;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get SubjectCode value
     * @return string|null
     */
    public function getSubjectCode()
    {
        return $this->SubjectCode;
    }
    /**
     * Set SubjectCode value
     * @param string $subjectCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public function setSubjectCode($subjectCode = null)
    {
        // validation for constraint: string
        if (!is_null($subjectCode) && !is_string($subjectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subjectCode, true), gettype($subjectCode)), __LINE__);
        }
        $this->SubjectCode = $subjectCode;
        return $this;
    }
}
