<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSPremiumCareFormType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipUPSPremiumCareFormType extends AbstractStructBase
{
    /**
     * The ShipmentDate
     * @var string
     */
    public $ShipmentDate;
    /**
     * The PageSize
     * @var string
     */
    public $PageSize;
    /**
     * The PrintType
     * @var string
     */
    public $PrintType;
    /**
     * The NumOfCopies
     * @var string
     */
    public $NumOfCopies;
    /**
     * The LanguageForUPSPremiumCare
     * @var \Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType
     */
    public $LanguageForUPSPremiumCare;
    /**
     * Constructor method for UPSPremiumCareFormType
     * @uses Ups_shipUPSPremiumCareFormType::setShipmentDate()
     * @uses Ups_shipUPSPremiumCareFormType::setPageSize()
     * @uses Ups_shipUPSPremiumCareFormType::setPrintType()
     * @uses Ups_shipUPSPremiumCareFormType::setNumOfCopies()
     * @uses Ups_shipUPSPremiumCareFormType::setLanguageForUPSPremiumCare()
     * @param string $shipmentDate
     * @param string $pageSize
     * @param string $printType
     * @param string $numOfCopies
     * @param \Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType $languageForUPSPremiumCare
     */
    public function __construct($shipmentDate = null, $pageSize = null, $printType = null, $numOfCopies = null, \Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType $languageForUPSPremiumCare = null)
    {
        $this
            ->setShipmentDate($shipmentDate)
            ->setPageSize($pageSize)
            ->setPrintType($printType)
            ->setNumOfCopies($numOfCopies)
            ->setLanguageForUPSPremiumCare($languageForUPSPremiumCare);
    }
    /**
     * Get ShipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremiumCareFormType
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get PageSize value
     * @return string|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param string $pageSize
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremiumCareFormType
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: string
        if (!is_null($pageSize) && !is_string($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @param string $printType
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremiumCareFormType
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: string
        if (!is_null($printType) && !is_string($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printType, true), gettype($printType)), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Get NumOfCopies value
     * @return string|null
     */
    public function getNumOfCopies()
    {
        return $this->NumOfCopies;
    }
    /**
     * Set NumOfCopies value
     * @param string $numOfCopies
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremiumCareFormType
     */
    public function setNumOfCopies($numOfCopies = null)
    {
        // validation for constraint: string
        if (!is_null($numOfCopies) && !is_string($numOfCopies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfCopies, true), gettype($numOfCopies)), __LINE__);
        }
        $this->NumOfCopies = $numOfCopies;
        return $this;
    }
    /**
     * Get LanguageForUPSPremiumCare value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType|null
     */
    public function getLanguageForUPSPremiumCare()
    {
        return $this->LanguageForUPSPremiumCare;
    }
    /**
     * Set LanguageForUPSPremiumCare value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType $languageForUPSPremiumCare
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremiumCareFormType
     */
    public function setLanguageForUPSPremiumCare(\Ups_ship\UPSshipStruct\Ups_shipLanguageForUPSPremiumCareType $languageForUPSPremiumCare = null)
    {
        $this->LanguageForUPSPremiumCare = $languageForUPSPremiumCare;
        return $this;
    }
}
