<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionReferenceType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipTransactionReferenceType extends AbstractStructBase
{
    /**
     * The CustomerContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerContext;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - usage: notused
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * Constructor method for TransactionReferenceType
     * @uses Ups_shipTransactionReferenceType::setCustomerContext()
     * @uses Ups_shipTransactionReferenceType::setTransactionIdentifier()
     * @param string $customerContext
     * @param string $transactionIdentifier
     */
    public function __construct($customerContext = null, $transactionIdentifier = null)
    {
        $this
            ->setCustomerContext($customerContext)
            ->setTransactionIdentifier($transactionIdentifier);
    }
    /**
     * Get CustomerContext value
     * @return string|null
     */
    public function getCustomerContext()
    {
        return $this->CustomerContext;
    }
    /**
     * Set CustomerContext value
     * @param string $customerContext
     * @return \Ups_ship\UPSshipStruct\Ups_shipTransactionReferenceType
     */
    public function setCustomerContext($customerContext = null)
    {
        // validation for constraint: string
        if (!is_null($customerContext) && !is_string($customerContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerContext, true), gettype($customerContext)), __LINE__);
        }
        $this->CustomerContext = $customerContext;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \Ups_ship\UPSshipStruct\Ups_shipTransactionReferenceType
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
}
