<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceNumberType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipReferenceNumberType extends AbstractStructBase
{
    /**
     * The BarCodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BarCodeIndicator;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ReferenceNumberType
     * @uses Ups_shipReferenceNumberType::setBarCodeIndicator()
     * @uses Ups_shipReferenceNumberType::setCode()
     * @uses Ups_shipReferenceNumberType::setValue()
     * @param string $barCodeIndicator
     * @param string $code
     * @param string $value
     */
    public function __construct($barCodeIndicator = null, $code = null, $value = null)
    {
        $this
            ->setBarCodeIndicator($barCodeIndicator)
            ->setCode($code)
            ->setValue($value);
    }
    /**
     * Get BarCodeIndicator value
     * @return string|null
     */
    public function getBarCodeIndicator()
    {
        return $this->BarCodeIndicator;
    }
    /**
     * Set BarCodeIndicator value
     * @param string $barCodeIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType
     */
    public function setBarCodeIndicator($barCodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($barCodeIndicator) && !is_string($barCodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barCodeIndicator, true), gettype($barCodeIndicator)), __LINE__);
        }
        $this->BarCodeIndicator = $barCodeIndicator;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
