<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSONotificationType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipPSONotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public $EMail;
    /**
     * Constructor method for PSONotificationType
     * @uses Ups_shipPSONotificationType::setNotificationCode()
     * @uses Ups_shipPSONotificationType::setEMail()
     * @param string $notificationCode
     * @param \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail
     */
    public function __construct($notificationCode = null, \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail
     * @return \Ups_ship\UPSshipStruct\Ups_shipPSONotificationType
     */
    public function setEMail(\Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
}
