<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NMFCType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipNMFCType extends AbstractStructBase
{
    /**
     * The PrimeCode
     * @var string
     */
    public $PrimeCode;
    /**
     * The SubCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubCode;
    /**
     * Constructor method for NMFCType
     * @uses Ups_shipNMFCType::setPrimeCode()
     * @uses Ups_shipNMFCType::setSubCode()
     * @param string $primeCode
     * @param string $subCode
     */
    public function __construct($primeCode = null, $subCode = null)
    {
        $this
            ->setPrimeCode($primeCode)
            ->setSubCode($subCode);
    }
    /**
     * Get PrimeCode value
     * @return string|null
     */
    public function getPrimeCode()
    {
        return $this->PrimeCode;
    }
    /**
     * Set PrimeCode value
     * @param string $primeCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipNMFCType
     */
    public function setPrimeCode($primeCode = null)
    {
        // validation for constraint: string
        if (!is_null($primeCode) && !is_string($primeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primeCode, true), gettype($primeCode)), __LINE__);
        }
        $this->PrimeCode = $primeCode;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipNMFCType
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCode, true), gettype($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
}
