<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipLabelType extends Ups_shipImageType
{
    /**
     * The GraphicImagePart
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $GraphicImagePart;
    /**
     * The InternationalSignatureGraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InternationalSignatureGraphicImage;
    /**
     * The HTMLImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTMLImage;
    /**
     * The PDF417
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PDF417;
    /**
     * Constructor method for LabelType
     * @uses Ups_shipLabelType::setGraphicImagePart()
     * @uses Ups_shipLabelType::setInternationalSignatureGraphicImage()
     * @uses Ups_shipLabelType::setHTMLImage()
     * @uses Ups_shipLabelType::setPDF417()
     * @param string[] $graphicImagePart
     * @param string $internationalSignatureGraphicImage
     * @param string $hTMLImage
     * @param string $pDF417
     */
    public function __construct(array $graphicImagePart = array(), $internationalSignatureGraphicImage = null, $hTMLImage = null, $pDF417 = null)
    {
        $this
            ->setGraphicImagePart($graphicImagePart)
            ->setInternationalSignatureGraphicImage($internationalSignatureGraphicImage)
            ->setHTMLImage($hTMLImage)
            ->setPDF417($pDF417);
    }
    /**
     * Get GraphicImagePart value
     * @return string[]|null
     */
    public function getGraphicImagePart()
    {
        return $this->GraphicImagePart;
    }
    /**
     * This method is responsible for validating the values passed to the setGraphicImagePart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGraphicImagePart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGraphicImagePartForArrayConstraintsFromSetGraphicImagePart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $labelTypeGraphicImagePartItem) {
            // validation for constraint: itemType
            if (!is_string($labelTypeGraphicImagePartItem)) {
                $invalidValues[] = is_object($labelTypeGraphicImagePartItem) ? get_class($labelTypeGraphicImagePartItem) : sprintf('%s(%s)', gettype($labelTypeGraphicImagePartItem), var_export($labelTypeGraphicImagePartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GraphicImagePart property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GraphicImagePart value
     * @throws \InvalidArgumentException
     * @param string[] $graphicImagePart
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public function setGraphicImagePart(array $graphicImagePart = array())
    {
        // validation for constraint: array
        if ('' !== ($graphicImagePartArrayErrorMessage = self::validateGraphicImagePartForArrayConstraintsFromSetGraphicImagePart($graphicImagePart))) {
            throw new \InvalidArgumentException($graphicImagePartArrayErrorMessage, __LINE__);
        }
        $this->GraphicImagePart = $graphicImagePart;
        return $this;
    }
    /**
     * Add item to GraphicImagePart value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public function addToGraphicImagePart($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GraphicImagePart property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GraphicImagePart[] = $item;
        return $this;
    }
    /**
     * Get InternationalSignatureGraphicImage value
     * @return string|null
     */
    public function getInternationalSignatureGraphicImage()
    {
        return $this->InternationalSignatureGraphicImage;
    }
    /**
     * Set InternationalSignatureGraphicImage value
     * @param string $internationalSignatureGraphicImage
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public function setInternationalSignatureGraphicImage($internationalSignatureGraphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($internationalSignatureGraphicImage) && !is_string($internationalSignatureGraphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalSignatureGraphicImage, true), gettype($internationalSignatureGraphicImage)), __LINE__);
        }
        $this->InternationalSignatureGraphicImage = $internationalSignatureGraphicImage;
        return $this;
    }
    /**
     * Get HTMLImage value
     * @return string|null
     */
    public function getHTMLImage()
    {
        return $this->HTMLImage;
    }
    /**
     * Set HTMLImage value
     * @param string $hTMLImage
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public function setHTMLImage($hTMLImage = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLImage) && !is_string($hTMLImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTMLImage, true), gettype($hTMLImage)), __LINE__);
        }
        $this->HTMLImage = $hTMLImage;
        return $this;
    }
    /**
     * Get PDF417 value
     * @return string|null
     */
    public function getPDF417()
    {
        return $this->PDF417;
    }
    /**
     * Set PDF417 value
     * @param string $pDF417
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelType
     */
    public function setPDF417($pDF417 = null)
    {
        // validation for constraint: string
        if (!is_null($pDF417) && !is_string($pDF417)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDF417, true), gettype($pDF417)), __LINE__);
        }
        $this->PDF417 = $pDF417;
        return $this;
    }
}
