<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipNotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType
     */
    public $EMail;
    /**
     * The VoiceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType
     */
    public $VoiceMessage;
    /**
     * The TextMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType
     */
    public $TextMessage;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipLocaleType
     */
    public $Locale;
    /**
     * Constructor method for NotificationType
     * @uses Ups_shipNotificationType::setNotificationCode()
     * @uses Ups_shipNotificationType::setEMail()
     * @uses Ups_shipNotificationType::setVoiceMessage()
     * @uses Ups_shipNotificationType::setTextMessage()
     * @uses Ups_shipNotificationType::setLocale()
     * @param string $notificationCode
     * @param \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @param \Ups_ship\UPSshipStruct\Ups_shipLocaleType $locale
     */
    public function __construct($notificationCode = null, \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail = null, \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null, \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType $textMessage = null, \Ups_ship\UPSshipStruct\Ups_shipLocaleType $locale = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail)
            ->setVoiceMessage($voiceMessage)
            ->setTextMessage($textMessage)
            ->setLocale($locale);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipNotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail
     * @return \Ups_ship\UPSshipStruct\Ups_shipNotificationType
     */
    public function setEMail(\Ups_ship\UPSshipStruct\Ups_shipEmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get VoiceMessage value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType|null
     */
    public function getVoiceMessage()
    {
        return $this->VoiceMessage;
    }
    /**
     * Set VoiceMessage value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @return \Ups_ship\UPSshipStruct\Ups_shipNotificationType
     */
    public function setVoiceMessage(\Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null)
    {
        $this->VoiceMessage = $voiceMessage;
        return $this;
    }
    /**
     * Get TextMessage value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType|null
     */
    public function getTextMessage()
    {
        return $this->TextMessage;
    }
    /**
     * Set TextMessage value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @return \Ups_ship\UPSshipStruct\Ups_shipNotificationType
     */
    public function setTextMessage(\Ups_ship\UPSshipStruct\Ups_shipShipmentServiceOptionsNotificationTextMessageType $textMessage = null)
    {
        $this->TextMessage = $textMessage;
        return $this;
    }
    /**
     * Get Locale value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLocaleType|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLocaleType $locale
     * @return \Ups_ship\UPSshipStruct\Ups_shipNotificationType
     */
    public function setLocale(\Ups_ship\UPSshipStruct\Ups_shipLocaleType $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
}
