<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipHandlingUnitsType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * Constructor method for HandlingUnitsType
     * @uses Ups_shipHandlingUnitsType::setQuantity()
     * @uses Ups_shipHandlingUnitsType::setType()
     * @uses Ups_shipHandlingUnitsType::setDimensions()
     * @param string $quantity
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions
     */
    public function __construct($quantity = null, \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type = null, \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsType
     */
    public function setType(\Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsType
     */
    public function setDimensions(\Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
}
