<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSPaymentInfoType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipFRSPaymentInfoType extends AbstractStructBase
{
    /**
     * The Type
     * @var \Ups_ship\UPSshipStruct\Ups_shipPaymentType
     */
    public $Type;
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType
     */
    public $Address;
    /**
     * Constructor method for FRSPaymentInfoType
     * @uses Ups_shipFRSPaymentInfoType::setType()
     * @uses Ups_shipFRSPaymentInfoType::setAccountNumber()
     * @uses Ups_shipFRSPaymentInfoType::setAddress()
     * @param \Ups_ship\UPSshipStruct\Ups_shipPaymentType $type
     * @param string $accountNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipPaymentType $type = null, $accountNumber = null, \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPaymentType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPaymentType $type
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSPaymentInfoType
     */
    public function setType(\Ups_ship\UPSshipStruct\Ups_shipPaymentType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSPaymentInfoType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSPaymentInfoType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
