<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipDryIceType extends AbstractStructBase
{
    /**
     * The RegulationSet
     * @var string
     */
    public $RegulationSet;
    /**
     * The DryIceWeight
     * @var \Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType
     */
    public $DryIceWeight;
    /**
     * The MedicalUseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MedicalUseIndicator;
    /**
     * Constructor method for DryIceType
     * @uses Ups_shipDryIceType::setRegulationSet()
     * @uses Ups_shipDryIceType::setDryIceWeight()
     * @uses Ups_shipDryIceType::setMedicalUseIndicator()
     * @param string $regulationSet
     * @param \Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType $dryIceWeight
     * @param string $medicalUseIndicator
     */
    public function __construct($regulationSet = null, \Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType $dryIceWeight = null, $medicalUseIndicator = null)
    {
        $this
            ->setRegulationSet($regulationSet)
            ->setDryIceWeight($dryIceWeight)
            ->setMedicalUseIndicator($medicalUseIndicator);
    }
    /**
     * Get RegulationSet value
     * @return string|null
     */
    public function getRegulationSet()
    {
        return $this->RegulationSet;
    }
    /**
     * Set RegulationSet value
     * @param string $regulationSet
     * @return \Ups_ship\UPSshipStruct\Ups_shipDryIceType
     */
    public function setRegulationSet($regulationSet = null)
    {
        // validation for constraint: string
        if (!is_null($regulationSet) && !is_string($regulationSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulationSet, true), gettype($regulationSet)), __LINE__);
        }
        $this->RegulationSet = $regulationSet;
        return $this;
    }
    /**
     * Get DryIceWeight value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType|null
     */
    public function getDryIceWeight()
    {
        return $this->DryIceWeight;
    }
    /**
     * Set DryIceWeight value
     * @param \Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType $dryIceWeight
     * @return \Ups_ship\UPSshipStruct\Ups_shipDryIceType
     */
    public function setDryIceWeight(\Ups_ship\UPSshipStruct\Ups_shipDryIceWeightType $dryIceWeight = null)
    {
        $this->DryIceWeight = $dryIceWeight;
        return $this;
    }
    /**
     * Get MedicalUseIndicator value
     * @return string|null
     */
    public function getMedicalUseIndicator()
    {
        return $this->MedicalUseIndicator;
    }
    /**
     * Set MedicalUseIndicator value
     * @param string $medicalUseIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipDryIceType
     */
    public function setMedicalUseIndicator($medicalUseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($medicalUseIndicator) && !is_string($medicalUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalUseIndicator, true), gettype($medicalUseIndicator)), __LINE__);
        }
        $this->MedicalUseIndicator = $medicalUseIndicator;
        return $this;
    }
}
