<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormImageType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipFormImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipImageFormatType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for FormImageType
     * @uses Ups_shipFormImageType::setImageFormat()
     * @uses Ups_shipFormImageType::setGraphicImage()
     * @param \Ups_ship\UPSshipStruct\Ups_shipImageFormatType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipImageFormatType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups_ship\UPSshipStruct\Ups_shipImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups_ship\UPSshipStruct\Ups_shipImageFormatType $imageFormat
     * @return \Ups_ship\UPSshipStruct\Ups_shipFormImageType
     */
    public function setImageFormat(\Ups_ship\UPSshipStruct\Ups_shipImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups_ship\UPSshipStruct\Ups_shipFormImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
