<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrokerageFeesType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipBrokerageFeesType extends AbstractStructBase
{
    /**
     * The ChargeName
     * @var string
     */
    public $ChargeName;
    /**
     * The ChargeAmount
     * @var string
     */
    public $ChargeAmount;
    /**
     * The TotalBrokerageFees
     * @var string
     */
    public $TotalBrokerageFees;
    /**
     * The TotalDuties
     * @var string
     */
    public $TotalDuties;
    /**
     * The TotalCommodityLevelTaxesAndFees
     * @var string
     */
    public $TotalCommodityLevelTaxesAndFees;
    /**
     * The TotalShipmentLevelTaxesAndFees
     * @var string
     */
    public $TotalShipmentLevelTaxesAndFees;
    /**
     * The TotalVAT
     * @var string
     */
    public $TotalVAT;
    /**
     * The GrandTotal
     * @var string
     */
    public $GrandTotal;
    /**
     * Constructor method for BrokerageFeesType
     * @uses Ups_shipBrokerageFeesType::setChargeName()
     * @uses Ups_shipBrokerageFeesType::setChargeAmount()
     * @uses Ups_shipBrokerageFeesType::setTotalBrokerageFees()
     * @uses Ups_shipBrokerageFeesType::setTotalDuties()
     * @uses Ups_shipBrokerageFeesType::setTotalCommodityLevelTaxesAndFees()
     * @uses Ups_shipBrokerageFeesType::setTotalShipmentLevelTaxesAndFees()
     * @uses Ups_shipBrokerageFeesType::setTotalVAT()
     * @uses Ups_shipBrokerageFeesType::setGrandTotal()
     * @param string $chargeName
     * @param string $chargeAmount
     * @param string $totalBrokerageFees
     * @param string $totalDuties
     * @param string $totalCommodityLevelTaxesAndFees
     * @param string $totalShipmentLevelTaxesAndFees
     * @param string $totalVAT
     * @param string $grandTotal
     */
    public function __construct($chargeName = null, $chargeAmount = null, $totalBrokerageFees = null, $totalDuties = null, $totalCommodityLevelTaxesAndFees = null, $totalShipmentLevelTaxesAndFees = null, $totalVAT = null, $grandTotal = null)
    {
        $this
            ->setChargeName($chargeName)
            ->setChargeAmount($chargeAmount)
            ->setTotalBrokerageFees($totalBrokerageFees)
            ->setTotalDuties($totalDuties)
            ->setTotalCommodityLevelTaxesAndFees($totalCommodityLevelTaxesAndFees)
            ->setTotalShipmentLevelTaxesAndFees($totalShipmentLevelTaxesAndFees)
            ->setTotalVAT($totalVAT)
            ->setGrandTotal($grandTotal);
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeName, true), gettype($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return string|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param string $chargeAmount
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($chargeAmount) && !is_string($chargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get TotalBrokerageFees value
     * @return string|null
     */
    public function getTotalBrokerageFees()
    {
        return $this->TotalBrokerageFees;
    }
    /**
     * Set TotalBrokerageFees value
     * @param string $totalBrokerageFees
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setTotalBrokerageFees($totalBrokerageFees = null)
    {
        // validation for constraint: string
        if (!is_null($totalBrokerageFees) && !is_string($totalBrokerageFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalBrokerageFees, true), gettype($totalBrokerageFees)), __LINE__);
        }
        $this->TotalBrokerageFees = $totalBrokerageFees;
        return $this;
    }
    /**
     * Get TotalDuties value
     * @return string|null
     */
    public function getTotalDuties()
    {
        return $this->TotalDuties;
    }
    /**
     * Set TotalDuties value
     * @param string $totalDuties
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setTotalDuties($totalDuties = null)
    {
        // validation for constraint: string
        if (!is_null($totalDuties) && !is_string($totalDuties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalDuties, true), gettype($totalDuties)), __LINE__);
        }
        $this->TotalDuties = $totalDuties;
        return $this;
    }
    /**
     * Get TotalCommodityLevelTaxesAndFees value
     * @return string|null
     */
    public function getTotalCommodityLevelTaxesAndFees()
    {
        return $this->TotalCommodityLevelTaxesAndFees;
    }
    /**
     * Set TotalCommodityLevelTaxesAndFees value
     * @param string $totalCommodityLevelTaxesAndFees
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setTotalCommodityLevelTaxesAndFees($totalCommodityLevelTaxesAndFees = null)
    {
        // validation for constraint: string
        if (!is_null($totalCommodityLevelTaxesAndFees) && !is_string($totalCommodityLevelTaxesAndFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalCommodityLevelTaxesAndFees, true), gettype($totalCommodityLevelTaxesAndFees)), __LINE__);
        }
        $this->TotalCommodityLevelTaxesAndFees = $totalCommodityLevelTaxesAndFees;
        return $this;
    }
    /**
     * Get TotalShipmentLevelTaxesAndFees value
     * @return string|null
     */
    public function getTotalShipmentLevelTaxesAndFees()
    {
        return $this->TotalShipmentLevelTaxesAndFees;
    }
    /**
     * Set TotalShipmentLevelTaxesAndFees value
     * @param string $totalShipmentLevelTaxesAndFees
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setTotalShipmentLevelTaxesAndFees($totalShipmentLevelTaxesAndFees = null)
    {
        // validation for constraint: string
        if (!is_null($totalShipmentLevelTaxesAndFees) && !is_string($totalShipmentLevelTaxesAndFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalShipmentLevelTaxesAndFees, true), gettype($totalShipmentLevelTaxesAndFees)), __LINE__);
        }
        $this->TotalShipmentLevelTaxesAndFees = $totalShipmentLevelTaxesAndFees;
        return $this;
    }
    /**
     * Get TotalVAT value
     * @return string|null
     */
    public function getTotalVAT()
    {
        return $this->TotalVAT;
    }
    /**
     * Set TotalVAT value
     * @param string $totalVAT
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setTotalVAT($totalVAT = null)
    {
        // validation for constraint: string
        if (!is_null($totalVAT) && !is_string($totalVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalVAT, true), gettype($totalVAT)), __LINE__);
        }
        $this->TotalVAT = $totalVAT;
        return $this;
    }
    /**
     * Get GrandTotal value
     * @return string|null
     */
    public function getGrandTotal()
    {
        return $this->GrandTotal;
    }
    /**
     * Set GrandTotal value
     * @param string $grandTotal
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public function setGrandTotal($grandTotal = null)
    {
        // validation for constraint: string
        if (!is_null($grandTotal) && !is_string($grandTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grandTotal, true), gettype($grandTotal)), __LINE__);
        }
        $this->GrandTotal = $grandTotal;
        return $this;
    }
}
