<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillShipperType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 */
class Ups_shipBillShipperType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipCreditCardType
     */
    public $CreditCard;
    /**
     * The AlternatePaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlternatePaymentMethod;
    /**
     * Constructor method for BillShipperType
     * @uses Ups_shipBillShipperType::setAccountNumber()
     * @uses Ups_shipBillShipperType::setCreditCard()
     * @uses Ups_shipBillShipperType::setAlternatePaymentMethod()
     * @param string $accountNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipCreditCardType $creditCard
     * @param string $alternatePaymentMethod
     */
    public function __construct($accountNumber = null, \Ups_ship\UPSshipStruct\Ups_shipCreditCardType $creditCard = null, $alternatePaymentMethod = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setCreditCard($creditCard)
            ->setAlternatePaymentMethod($alternatePaymentMethod);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillShipperType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get CreditCard value
     * @return \Ups_ship\UPSshipStruct\Ups_shipCreditCardType|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \Ups_ship\UPSshipStruct\Ups_shipCreditCardType $creditCard
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillShipperType
     */
    public function setCreditCard(\Ups_ship\UPSshipStruct\Ups_shipCreditCardType $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get AlternatePaymentMethod value
     * @return string|null
     */
    public function getAlternatePaymentMethod()
    {
        return $this->AlternatePaymentMethod;
    }
    /**
     * Set AlternatePaymentMethod value
     * @param string $alternatePaymentMethod
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillShipperType
     */
    public function setAlternatePaymentMethod($alternatePaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($alternatePaymentMethod) && !is_string($alternatePaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatePaymentMethod, true), gettype($alternatePaymentMethod)), __LINE__);
        }
        $this->AlternatePaymentMethod = $alternatePaymentMethod;
        return $this;
    }
}
