<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserPark StructType
 * @subpackage Structs
 */
class UserPark extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $position;
    /**
     * The cn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cn;
    /**
     * Constructor method for UserPark
     * @uses UserPark::setCall()
     * @uses UserPark::setPosition()
     * @uses UserPark::setCn()
     * @param int $call
     * @param int $position
     * @param string $cn
     */
    public function __construct($call = null, $position = null, $cn = null)
    {
        $this
            ->setCall($call)
            ->setPosition($position)
            ->setCn($cn);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserPark
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get position value
     * @return int
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param int $position
     * @return \StructType\UserPark
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get cn value
     * @return string|null
     */
    public function getCn()
    {
        return $this->cn;
    }
    /**
     * Set cn value
     * @param string $cn
     * @return \StructType\UserPark
     */
    public function setCn($cn = null)
    {
        // validation for constraint: string
        if (!is_null($cn) && !is_string($cn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cn)), __LINE__);
        }
        $this->cn = $cn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
