<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserHold StructType
 * @subpackage Structs
 */
class UserHold extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The remote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $remote;
    /**
     * Constructor method for UserHold
     * @uses UserHold::setCall()
     * @uses UserHold::setRemote()
     * @param int $call
     * @param bool $remote
     */
    public function __construct($call = null, $remote = null)
    {
        $this
            ->setCall($call)
            ->setRemote($remote);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserHold
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get remote value
     * @return bool
     */
    public function getRemote()
    {
        return $this->remote;
    }
    /**
     * Set remote value
     * @param bool $remote
     * @return \StructType\UserHold
     */
    public function setRemote($remote = null)
    {
        // validation for constraint: boolean
        if (!is_null($remote) && !is_bool($remote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($remote)), __LINE__);
        }
        $this->remote = $remote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserHold
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
