<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserFindDestination StructType
 * @subpackage Structs
 */
class UserFindDestination extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The e164
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323;
    /**
     * Constructor method for UserFindDestination
     * @uses UserFindDestination::setUser()
     * @uses UserFindDestination::setE164()
     * @uses UserFindDestination::setH323()
     * @param int $user
     * @param string $e164
     * @param string $h323
     */
    public function __construct($user = null, $e164 = null, $h323 = null)
    {
        $this
            ->setUser($user)
            ->setE164($e164)
            ->setH323($h323);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\UserFindDestination
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get e164 value
     * @return string|null
     */
    public function getE164()
    {
        return $this->e164;
    }
    /**
     * Set e164 value
     * @param string $e164
     * @return \StructType\UserFindDestination
     */
    public function setE164($e164 = null)
    {
        // validation for constraint: string
        if (!is_null($e164) && !is_string($e164)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164)), __LINE__);
        }
        $this->e164 = $e164;
        return $this;
    }
    /**
     * Get h323 value
     * @return string|null
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\UserFindDestination
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserFindDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
