<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UserInitialize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserInitialize $parameters
     * @return \StructType\UserInitializeResponse|bool
     */
    public function UserInitialize(\StructType\UserInitialize $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserInitialize($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserEnd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserEnd $parameters
     * @return \StructType\UserEndResponse|bool
     */
    public function UserEnd(\StructType\UserEnd $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserEnd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserCall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserCall $parameters
     * @return \StructType\UserCallResponse|bool
     */
    public function UserCall(\StructType\UserCall $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserCall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserClear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserClear $parameters
     * @return \StructType\UserClearResponse|bool
     */
    public function UserClear(\StructType\UserClear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserClear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserConnect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserConnect $parameters
     * @return \StructType\UserConnectResponse|bool
     */
    public function UserConnect(\StructType\UserConnect $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserConnect($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserRc $parameters
     * @return \StructType\UserRcResponse|bool
     */
    public function UserRc(\StructType\UserRc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserInfoTx $parameters
     * @return \StructType\UserInfoTxResponse|bool
     */
    public function UserInfo(\StructType\UserInfoTx $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserDTMF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserDTMF $parameters
     * @return \StructType\UserDTMFResponse|bool
     */
    public function UserDTMF(\StructType\UserDTMF $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserDTMF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserUUI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserUUI $parameters
     * @return \StructType\UserUUIResponse|bool
     */
    public function UserUUI(\StructType\UserUUI $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserUUI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserPickup $parameters
     * @return \StructType\UserPickupResponse|bool
     */
    public function UserPickup(\StructType\UserPickup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRedirect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserRedirect $parameters
     * @return \StructType\UserRedirectResponse|bool
     */
    public function UserRedirect(\StructType\UserRedirect $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRedirect($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserReroute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserReroute $parameters
     * @return \StructType\UserRerouteResponse|bool
     */
    public function UserReroute(\StructType\UserReroute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserReroute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserTransfer $parameters
     * @return \StructType\UserTransferResponse|bool
     */
    public function UserTransfer(\StructType\UserTransfer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserMediaTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserMediaTransfer $parameters
     * @return \StructType\UserMediaTransferResponse|bool
     */
    public function UserMediaTransfer(\StructType\UserMediaTransfer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserMediaTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserCtComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserCtComplete $parameters
     * @return \StructType\UserCtCompleteResponse|bool
     */
    public function UserCtComplete(\StructType\UserCtComplete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserCtComplete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserHold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserHold $parameters
     * @return \StructType\UserHoldResponse|bool
     */
    public function UserHold(\StructType\UserHold $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserHold($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserRetrieve
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserRetrieve $parameters
     * @return \StructType\UserRetrieveResponse|bool
     */
    public function UserRetrieve(\StructType\UserRetrieve $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserRetrieve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserPark $parameters
     * @return \StructType\UserParkResponse|bool
     */
    public function UserPark(\StructType\UserPark $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserPark($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserMessage $parameters
     * @return \StructType\UserMessageResponse|bool
     */
    public function UserMessage(\StructType\UserMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserLocalNum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserLocalNum $parameters
     * @return \StructType\UserLocalNumResponse|bool
     */
    public function UserLocalNum(\StructType\UserLocalNum $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserLocalNum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserFindDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserFindDestination $parameters
     * @return \StructType\UserFindDestinationResponse|bool
     */
    public function UserFindDestination(\StructType\UserFindDestination $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserFindDestination($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserLicense
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserLicense $parameters
     * @return \StructType\UserLicenseResponse|bool
     */
    public function UserLicense(\StructType\UserLicense $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UserLicense($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserCallResponse|\StructType\UserClearResponse|\StructType\UserConnectResponse|\StructType\UserCtCompleteResponse|\StructType\UserDTMFResponse|\StructType\UserEndResponse|\StructType\UserFindDestinationResponse|\StructType\UserHoldResponse|\StructType\UserInfoTxResponse|\StructType\UserInitializeResponse|\StructType\UserLicenseResponse|\StructType\UserLocalNumResponse|\StructType\UserMediaTransferResponse|\StructType\UserMessageResponse|\StructType\UserParkResponse|\StructType\UserPickupResponse|\StructType\UserRcResponse|\StructType\UserRedirectResponse|\StructType\UserRerouteResponse|\StructType\UserRetrieveResponse|\StructType\UserTransferResponse|\StructType\UserUUIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
