<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionResponse StructType
 * @subpackage Structs
 */
class VersionResponse extends AbstractStructBase
{
    /**
     * The VersionResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VersionResult;
    /**
     * The GatekeeperID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GatekeeperID;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The FirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * Constructor method for VersionResponse
     * @uses VersionResponse::setVersionResult()
     * @uses VersionResponse::setGatekeeperID()
     * @uses VersionResponse::setLocation()
     * @uses VersionResponse::setFirmwareVersion()
     * @uses VersionResponse::setSerialNumber()
     * @param int $versionResult
     * @param string $gatekeeperID
     * @param string $location
     * @param string $firmwareVersion
     * @param string $serialNumber
     */
    public function __construct($versionResult = null, $gatekeeperID = null, $location = null, $firmwareVersion = null, $serialNumber = null)
    {
        $this
            ->setVersionResult($versionResult)
            ->setGatekeeperID($gatekeeperID)
            ->setLocation($location)
            ->setFirmwareVersion($firmwareVersion)
            ->setSerialNumber($serialNumber);
    }
    /**
     * Get VersionResult value
     * @return int
     */
    public function getVersionResult()
    {
        return $this->VersionResult;
    }
    /**
     * Set VersionResult value
     * @param int $versionResult
     * @return \StructType\VersionResponse
     */
    public function setVersionResult($versionResult = null)
    {
        // validation for constraint: int
        if (!is_null($versionResult) && !is_numeric($versionResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionResult)), __LINE__);
        }
        $this->VersionResult = $versionResult;
        return $this;
    }
    /**
     * Get GatekeeperID value
     * @return string|null
     */
    public function getGatekeeperID()
    {
        return $this->GatekeeperID;
    }
    /**
     * Set GatekeeperID value
     * @param string $gatekeeperID
     * @return \StructType\VersionResponse
     */
    public function setGatekeeperID($gatekeeperID = null)
    {
        // validation for constraint: string
        if (!is_null($gatekeeperID) && !is_string($gatekeeperID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatekeeperID)), __LINE__);
        }
        $this->GatekeeperID = $gatekeeperID;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\VersionResponse
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \StructType\VersionResponse
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\VersionResponse
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
