<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSSecurity StructType
 * @subpackage Structs
 */
class UPSSecurity extends AbstractStructBase
{
    /**
     * The UsernameToken
     * @var \StructType\UsernameToken
     */
    public $UsernameToken;
    /**
     * The ServiceAccessToken
     * @var \StructType\ServiceAccessToken
     */
    public $ServiceAccessToken;
    /**
     * Constructor method for UPSSecurity
     * @uses UPSSecurity::setUsernameToken()
     * @uses UPSSecurity::setServiceAccessToken()
     * @param \StructType\UsernameToken $usernameToken
     * @param \StructType\ServiceAccessToken $serviceAccessToken
     */
    public function __construct(\StructType\UsernameToken $usernameToken = null, \StructType\ServiceAccessToken $serviceAccessToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setServiceAccessToken($serviceAccessToken);
    }
    /**
     * Get UsernameToken value
     * @return \StructType\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \StructType\UsernameToken $usernameToken
     * @return \StructType\UPSSecurity
     */
    public function setUsernameToken(\StructType\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get ServiceAccessToken value
     * @return \StructType\ServiceAccessToken|null
     */
    public function getServiceAccessToken()
    {
        return $this->ServiceAccessToken;
    }
    /**
     * Set ServiceAccessToken value
     * @param \StructType\ServiceAccessToken $serviceAccessToken
     * @return \StructType\UPSSecurity
     */
    public function setServiceAccessToken(\StructType\ServiceAccessToken $serviceAccessToken = null)
    {
        $this->ServiceAccessToken = $serviceAccessToken;
        return $this;
    }
}
