<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSPremiumCareFormType StructType
 * @subpackage Structs
 */
class UPSPremiumCareFormType extends AbstractStructBase
{
    /**
     * The ShipmentDate
     * @var string
     */
    public $ShipmentDate;
    /**
     * The PageSize
     * @var string
     */
    public $PageSize;
    /**
     * The PrintType
     * @var string
     */
    public $PrintType;
    /**
     * The NumOfCopies
     * @var string
     */
    public $NumOfCopies;
    /**
     * The LanguageForUPSPremiumCare
     * @var \StructType\LanguageForUPSPremiumCareType
     */
    public $LanguageForUPSPremiumCare;
    /**
     * Constructor method for UPSPremiumCareFormType
     * @uses UPSPremiumCareFormType::setShipmentDate()
     * @uses UPSPremiumCareFormType::setPageSize()
     * @uses UPSPremiumCareFormType::setPrintType()
     * @uses UPSPremiumCareFormType::setNumOfCopies()
     * @uses UPSPremiumCareFormType::setLanguageForUPSPremiumCare()
     * @param string $shipmentDate
     * @param string $pageSize
     * @param string $printType
     * @param string $numOfCopies
     * @param \StructType\LanguageForUPSPremiumCareType $languageForUPSPremiumCare
     */
    public function __construct($shipmentDate = null, $pageSize = null, $printType = null, $numOfCopies = null, \StructType\LanguageForUPSPremiumCareType $languageForUPSPremiumCare = null)
    {
        $this
            ->setShipmentDate($shipmentDate)
            ->setPageSize($pageSize)
            ->setPrintType($printType)
            ->setNumOfCopies($numOfCopies)
            ->setLanguageForUPSPremiumCare($languageForUPSPremiumCare);
    }
    /**
     * Get ShipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \StructType\UPSPremiumCareFormType
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get PageSize value
     * @return string|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param string $pageSize
     * @return \StructType\UPSPremiumCareFormType
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: string
        if (!is_null($pageSize) && !is_string($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @param string $printType
     * @return \StructType\UPSPremiumCareFormType
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: string
        if (!is_null($printType) && !is_string($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printType, true), gettype($printType)), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Get NumOfCopies value
     * @return string|null
     */
    public function getNumOfCopies()
    {
        return $this->NumOfCopies;
    }
    /**
     * Set NumOfCopies value
     * @param string $numOfCopies
     * @return \StructType\UPSPremiumCareFormType
     */
    public function setNumOfCopies($numOfCopies = null)
    {
        // validation for constraint: string
        if (!is_null($numOfCopies) && !is_string($numOfCopies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfCopies, true), gettype($numOfCopies)), __LINE__);
        }
        $this->NumOfCopies = $numOfCopies;
        return $this;
    }
    /**
     * Get LanguageForUPSPremiumCare value
     * @return \StructType\LanguageForUPSPremiumCareType|null
     */
    public function getLanguageForUPSPremiumCare()
    {
        return $this->LanguageForUPSPremiumCare;
    }
    /**
     * Set LanguageForUPSPremiumCare value
     * @param \StructType\LanguageForUPSPremiumCareType $languageForUPSPremiumCare
     * @return \StructType\UPSPremiumCareFormType
     */
    public function setLanguageForUPSPremiumCare(\StructType\LanguageForUPSPremiumCareType $languageForUPSPremiumCare = null)
    {
        $this->LanguageForUPSPremiumCare = $languageForUPSPremiumCare;
        return $this;
    }
}
