<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperFiledType StructType
 * @subpackage Structs
 */
class ShipperFiledType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PreDepartureITNNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PreDepartureITNNumber;
    /**
     * The ExemptionLegend
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExemptionLegend;
    /**
     * The EEIShipmentReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EEIShipmentReferenceNumber;
    /**
     * Constructor method for ShipperFiledType
     * @uses ShipperFiledType::setCode()
     * @uses ShipperFiledType::setDescription()
     * @uses ShipperFiledType::setPreDepartureITNNumber()
     * @uses ShipperFiledType::setExemptionLegend()
     * @uses ShipperFiledType::setEEIShipmentReferenceNumber()
     * @param string $code
     * @param string $description
     * @param string $preDepartureITNNumber
     * @param string $exemptionLegend
     * @param string $eEIShipmentReferenceNumber
     */
    public function __construct($code = null, $description = null, $preDepartureITNNumber = null, $exemptionLegend = null, $eEIShipmentReferenceNumber = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setPreDepartureITNNumber($preDepartureITNNumber)
            ->setExemptionLegend($exemptionLegend)
            ->setEEIShipmentReferenceNumber($eEIShipmentReferenceNumber);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ShipperFiledType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShipperFiledType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PreDepartureITNNumber value
     * @return string|null
     */
    public function getPreDepartureITNNumber()
    {
        return $this->PreDepartureITNNumber;
    }
    /**
     * Set PreDepartureITNNumber value
     * @param string $preDepartureITNNumber
     * @return \StructType\ShipperFiledType
     */
    public function setPreDepartureITNNumber($preDepartureITNNumber = null)
    {
        // validation for constraint: string
        if (!is_null($preDepartureITNNumber) && !is_string($preDepartureITNNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preDepartureITNNumber, true), gettype($preDepartureITNNumber)), __LINE__);
        }
        $this->PreDepartureITNNumber = $preDepartureITNNumber;
        return $this;
    }
    /**
     * Get ExemptionLegend value
     * @return string|null
     */
    public function getExemptionLegend()
    {
        return $this->ExemptionLegend;
    }
    /**
     * Set ExemptionLegend value
     * @param string $exemptionLegend
     * @return \StructType\ShipperFiledType
     */
    public function setExemptionLegend($exemptionLegend = null)
    {
        // validation for constraint: string
        if (!is_null($exemptionLegend) && !is_string($exemptionLegend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exemptionLegend, true), gettype($exemptionLegend)), __LINE__);
        }
        $this->ExemptionLegend = $exemptionLegend;
        return $this;
    }
    /**
     * Get EEIShipmentReferenceNumber value
     * @return string|null
     */
    public function getEEIShipmentReferenceNumber()
    {
        return $this->EEIShipmentReferenceNumber;
    }
    /**
     * Set EEIShipmentReferenceNumber value
     * @param string $eEIShipmentReferenceNumber
     * @return \StructType\ShipperFiledType
     */
    public function setEEIShipmentReferenceNumber($eEIShipmentReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eEIShipmentReferenceNumber) && !is_string($eEIShipmentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eEIShipmentReferenceNumber, true), gettype($eEIShipmentReferenceNumber)), __LINE__);
        }
        $this->EEIShipmentReferenceNumber = $eEIShipmentReferenceNumber;
        return $this;
    }
}
