<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentChargeType StructType
 * @subpackage Structs
 */
class ShipmentChargeType extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The BillShipper
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillShipperType
     */
    public $BillShipper;
    /**
     * The BillReceiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillReceiverType
     */
    public $BillReceiver;
    /**
     * The BillThirdParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillThirdPartyChargeType
     */
    public $BillThirdParty;
    /**
     * The ConsigneeBilledIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeBilledIndicator;
    /**
     * Constructor method for ShipmentChargeType
     * @uses ShipmentChargeType::setType()
     * @uses ShipmentChargeType::setBillShipper()
     * @uses ShipmentChargeType::setBillReceiver()
     * @uses ShipmentChargeType::setBillThirdParty()
     * @uses ShipmentChargeType::setConsigneeBilledIndicator()
     * @param string $type
     * @param \StructType\BillShipperType $billShipper
     * @param \StructType\BillReceiverType $billReceiver
     * @param \StructType\BillThirdPartyChargeType $billThirdParty
     * @param string $consigneeBilledIndicator
     */
    public function __construct($type = null, \StructType\BillShipperType $billShipper = null, \StructType\BillReceiverType $billReceiver = null, \StructType\BillThirdPartyChargeType $billThirdParty = null, $consigneeBilledIndicator = null)
    {
        $this
            ->setType($type)
            ->setBillShipper($billShipper)
            ->setBillReceiver($billReceiver)
            ->setBillThirdParty($billThirdParty)
            ->setConsigneeBilledIndicator($consigneeBilledIndicator);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ShipmentChargeType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get BillShipper value
     * @return \StructType\BillShipperType|null
     */
    public function getBillShipper()
    {
        return $this->BillShipper;
    }
    /**
     * Set BillShipper value
     * @param \StructType\BillShipperType $billShipper
     * @return \StructType\ShipmentChargeType
     */
    public function setBillShipper(\StructType\BillShipperType $billShipper = null)
    {
        $this->BillShipper = $billShipper;
        return $this;
    }
    /**
     * Get BillReceiver value
     * @return \StructType\BillReceiverType|null
     */
    public function getBillReceiver()
    {
        return $this->BillReceiver;
    }
    /**
     * Set BillReceiver value
     * @param \StructType\BillReceiverType $billReceiver
     * @return \StructType\ShipmentChargeType
     */
    public function setBillReceiver(\StructType\BillReceiverType $billReceiver = null)
    {
        $this->BillReceiver = $billReceiver;
        return $this;
    }
    /**
     * Get BillThirdParty value
     * @return \StructType\BillThirdPartyChargeType|null
     */
    public function getBillThirdParty()
    {
        return $this->BillThirdParty;
    }
    /**
     * Set BillThirdParty value
     * @param \StructType\BillThirdPartyChargeType $billThirdParty
     * @return \StructType\ShipmentChargeType
     */
    public function setBillThirdParty(\StructType\BillThirdPartyChargeType $billThirdParty = null)
    {
        $this->BillThirdParty = $billThirdParty;
        return $this;
    }
    /**
     * Get ConsigneeBilledIndicator value
     * @return string|null
     */
    public function getConsigneeBilledIndicator()
    {
        return $this->ConsigneeBilledIndicator;
    }
    /**
     * Set ConsigneeBilledIndicator value
     * @param string $consigneeBilledIndicator
     * @return \StructType\ShipmentChargeType
     */
    public function setConsigneeBilledIndicator($consigneeBilledIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeBilledIndicator) && !is_string($consigneeBilledIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeBilledIndicator, true), gettype($consigneeBilledIndicator)), __LINE__);
        }
        $this->ConsigneeBilledIndicator = $consigneeBilledIndicator;
        return $this;
    }
}
