<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipPhoneType StructType
 * @subpackage Structs
 */
class ShipPhoneType extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Extension;
    /**
     * Constructor method for ShipPhoneType
     * @uses ShipPhoneType::setNumber()
     * @uses ShipPhoneType::setExtension()
     * @param string $number
     * @param string $extension
     */
    public function __construct($number = null, $extension = null)
    {
        $this
            ->setNumber($number)
            ->setExtension($extension);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\ShipPhoneType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\ShipPhoneType
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
}
