<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipAcceptRequest StructType
 * @subpackage Structs
 */
class ShipAcceptRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \StructType\RequestType
     */
    public $Request;
    /**
     * The ShipmentDigest
     * @var string
     */
    public $ShipmentDigest;
    /**
     * Constructor method for ShipAcceptRequest
     * @uses ShipAcceptRequest::setRequest()
     * @uses ShipAcceptRequest::setShipmentDigest()
     * @param \StructType\RequestType $request
     * @param string $shipmentDigest
     */
    public function __construct(\StructType\RequestType $request = null, $shipmentDigest = null)
    {
        $this
            ->setRequest($request)
            ->setShipmentDigest($shipmentDigest);
    }
    /**
     * Get Request value
     * @return \StructType\RequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\RequestType $request
     * @return \StructType\ShipAcceptRequest
     */
    public function setRequest(\StructType\RequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ShipmentDigest value
     * @return string|null
     */
    public function getShipmentDigest()
    {
        return $this->ShipmentDigest;
    }
    /**
     * Set ShipmentDigest value
     * @param string $shipmentDigest
     * @return \StructType\ShipAcceptRequest
     */
    public function setShipmentDigest($shipmentDigest = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDigest) && !is_string($shipmentDigest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDigest, true), gettype($shipmentDigest)), __LINE__);
        }
        $this->ShipmentDigest = $shipmentDigest;
        return $this;
    }
}
