<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceNumberType StructType
 * @subpackage Structs
 */
class ReferenceNumberType extends AbstractStructBase
{
    /**
     * The BarCodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BarCodeIndicator;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ReferenceNumberType
     * @uses ReferenceNumberType::setBarCodeIndicator()
     * @uses ReferenceNumberType::setCode()
     * @uses ReferenceNumberType::setValue()
     * @param string $barCodeIndicator
     * @param string $code
     * @param string $value
     */
    public function __construct($barCodeIndicator = null, $code = null, $value = null)
    {
        $this
            ->setBarCodeIndicator($barCodeIndicator)
            ->setCode($code)
            ->setValue($value);
    }
    /**
     * Get BarCodeIndicator value
     * @return string|null
     */
    public function getBarCodeIndicator()
    {
        return $this->BarCodeIndicator;
    }
    /**
     * Set BarCodeIndicator value
     * @param string $barCodeIndicator
     * @return \StructType\ReferenceNumberType
     */
    public function setBarCodeIndicator($barCodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($barCodeIndicator) && !is_string($barCodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barCodeIndicator, true), gettype($barCodeIndicator)), __LINE__);
        }
        $this->BarCodeIndicator = $barCodeIndicator;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ReferenceNumberType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\ReferenceNumberType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
