<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreAlertEMailMessageType StructType
 * @subpackage Structs
 */
class PreAlertEMailMessageType extends AbstractStructBase
{
    /**
     * The EMailAddress
     * @var string
     */
    public $EMailAddress;
    /**
     * The UndeliverableEMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UndeliverableEMailAddress;
    /**
     * Constructor method for PreAlertEMailMessageType
     * @uses PreAlertEMailMessageType::setEMailAddress()
     * @uses PreAlertEMailMessageType::setUndeliverableEMailAddress()
     * @param string $eMailAddress
     * @param string $undeliverableEMailAddress
     */
    public function __construct($eMailAddress = null, $undeliverableEMailAddress = null)
    {
        $this
            ->setEMailAddress($eMailAddress)
            ->setUndeliverableEMailAddress($undeliverableEMailAddress);
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \StructType\PreAlertEMailMessageType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get UndeliverableEMailAddress value
     * @return string|null
     */
    public function getUndeliverableEMailAddress()
    {
        return $this->UndeliverableEMailAddress;
    }
    /**
     * Set UndeliverableEMailAddress value
     * @param string $undeliverableEMailAddress
     * @return \StructType\PreAlertEMailMessageType
     */
    public function setUndeliverableEMailAddress($undeliverableEMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($undeliverableEMailAddress) && !is_string($undeliverableEMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undeliverableEMailAddress, true), gettype($undeliverableEMailAddress)), __LINE__);
        }
        $this->UndeliverableEMailAddress = $undeliverableEMailAddress;
        return $this;
    }
}
