<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackingListInfoType StructType
 * @subpackage Structs
 */
class PackingListInfoType extends AbstractStructBase
{
    /**
     * The PackageAssociated
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PackageAssociatedType[]
     */
    public $PackageAssociated;
    /**
     * Constructor method for PackingListInfoType
     * @uses PackingListInfoType::setPackageAssociated()
     * @param \StructType\PackageAssociatedType[] $packageAssociated
     */
    public function __construct(array $packageAssociated = array())
    {
        $this
            ->setPackageAssociated($packageAssociated);
    }
    /**
     * Get PackageAssociated value
     * @return \StructType\PackageAssociatedType[]|null
     */
    public function getPackageAssociated()
    {
        return $this->PackageAssociated;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageAssociated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageAssociated method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageAssociatedForArrayConstraintsFromSetPackageAssociated(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packingListInfoTypePackageAssociatedItem) {
            // validation for constraint: itemType
            if (!$packingListInfoTypePackageAssociatedItem instanceof \StructType\PackageAssociatedType) {
                $invalidValues[] = is_object($packingListInfoTypePackageAssociatedItem) ? get_class($packingListInfoTypePackageAssociatedItem) : sprintf('%s(%s)', gettype($packingListInfoTypePackageAssociatedItem), var_export($packingListInfoTypePackageAssociatedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageAssociated property can only contain items of type \StructType\PackageAssociatedType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageAssociated value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageAssociatedType[] $packageAssociated
     * @return \StructType\PackingListInfoType
     */
    public function setPackageAssociated(array $packageAssociated = array())
    {
        // validation for constraint: array
        if ('' !== ($packageAssociatedArrayErrorMessage = self::validatePackageAssociatedForArrayConstraintsFromSetPackageAssociated($packageAssociated))) {
            throw new \InvalidArgumentException($packageAssociatedArrayErrorMessage, __LINE__);
        }
        $this->PackageAssociated = $packageAssociated;
        return $this;
    }
    /**
     * Add item to PackageAssociated value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageAssociatedType $item
     * @return \StructType\PackingListInfoType
     */
    public function addToPackageAssociated(\StructType\PackageAssociatedType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageAssociatedType) {
            throw new \InvalidArgumentException(sprintf('The PackageAssociated property can only contain items of type \StructType\PackageAssociatedType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageAssociated[] = $item;
        return $this;
    }
}
