<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PalletDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PalletDescription;
    /**
     * The NumOfPieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPieces;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UnitPrice;
    /**
     * The Packaging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackagingType
     */
    public $Packaging;
    /**
     * The Dimensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DimensionsType
     */
    public $Dimensions;
    /**
     * The DimWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageWeightType
     */
    public $DimWeight;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageWeightType
     */
    public $PackageWeight;
    /**
     * The LargePackageIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LargePackageIndicator;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The AdditionalHandlingIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalHandlingIndicator;
    /**
     * The PackageServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageServiceOptionsType
     */
    public $PackageServiceOptions;
    /**
     * The Commodity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommodityType
     */
    public $Commodity;
    /**
     * The HazMatPackageInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HazMatPackageInformationType
     */
    public $HazMatPackageInformation;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CodeDescriptionType
     */
    public $SimpleRate;
    /**
     * The UPSPremier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UPSPremierType
     */
    public $UPSPremier;
    /**
     * The OversizeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OversizeIndicator;
    /**
     * The MinimumBillableWeightIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumBillableWeightIndicator;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setDescription()
     * @uses PackageType::setPalletDescription()
     * @uses PackageType::setNumOfPieces()
     * @uses PackageType::setUnitPrice()
     * @uses PackageType::setPackaging()
     * @uses PackageType::setDimensions()
     * @uses PackageType::setDimWeight()
     * @uses PackageType::setPackageWeight()
     * @uses PackageType::setLargePackageIndicator()
     * @uses PackageType::setReferenceNumber()
     * @uses PackageType::setAdditionalHandlingIndicator()
     * @uses PackageType::setPackageServiceOptions()
     * @uses PackageType::setCommodity()
     * @uses PackageType::setHazMatPackageInformation()
     * @uses PackageType::setSimpleRate()
     * @uses PackageType::setUPSPremier()
     * @uses PackageType::setOversizeIndicator()
     * @uses PackageType::setMinimumBillableWeightIndicator()
     * @param string $description
     * @param string $palletDescription
     * @param string $numOfPieces
     * @param string $unitPrice
     * @param \StructType\PackagingType $packaging
     * @param \StructType\DimensionsType $dimensions
     * @param \StructType\PackageWeightType $dimWeight
     * @param \StructType\PackageWeightType $packageWeight
     * @param string $largePackageIndicator
     * @param \StructType\ReferenceNumberType[] $referenceNumber
     * @param string $additionalHandlingIndicator
     * @param \StructType\PackageServiceOptionsType $packageServiceOptions
     * @param \StructType\CommodityType $commodity
     * @param \StructType\HazMatPackageInformationType $hazMatPackageInformation
     * @param \StructType\CodeDescriptionType $simpleRate
     * @param \StructType\UPSPremierType $uPSPremier
     * @param string $oversizeIndicator
     * @param string $minimumBillableWeightIndicator
     */
    public function __construct($description = null, $palletDescription = null, $numOfPieces = null, $unitPrice = null, \StructType\PackagingType $packaging = null, \StructType\DimensionsType $dimensions = null, \StructType\PackageWeightType $dimWeight = null, \StructType\PackageWeightType $packageWeight = null, $largePackageIndicator = null, array $referenceNumber = array(), $additionalHandlingIndicator = null, \StructType\PackageServiceOptionsType $packageServiceOptions = null, \StructType\CommodityType $commodity = null, \StructType\HazMatPackageInformationType $hazMatPackageInformation = null, \StructType\CodeDescriptionType $simpleRate = null, \StructType\UPSPremierType $uPSPremier = null, $oversizeIndicator = null, $minimumBillableWeightIndicator = null)
    {
        $this
            ->setDescription($description)
            ->setPalletDescription($palletDescription)
            ->setNumOfPieces($numOfPieces)
            ->setUnitPrice($unitPrice)
            ->setPackaging($packaging)
            ->setDimensions($dimensions)
            ->setDimWeight($dimWeight)
            ->setPackageWeight($packageWeight)
            ->setLargePackageIndicator($largePackageIndicator)
            ->setReferenceNumber($referenceNumber)
            ->setAdditionalHandlingIndicator($additionalHandlingIndicator)
            ->setPackageServiceOptions($packageServiceOptions)
            ->setCommodity($commodity)
            ->setHazMatPackageInformation($hazMatPackageInformation)
            ->setSimpleRate($simpleRate)
            ->setUPSPremier($uPSPremier)
            ->setOversizeIndicator($oversizeIndicator)
            ->setMinimumBillableWeightIndicator($minimumBillableWeightIndicator);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PackageType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PalletDescription value
     * @return string|null
     */
    public function getPalletDescription()
    {
        return $this->PalletDescription;
    }
    /**
     * Set PalletDescription value
     * @param string $palletDescription
     * @return \StructType\PackageType
     */
    public function setPalletDescription($palletDescription = null)
    {
        // validation for constraint: string
        if (!is_null($palletDescription) && !is_string($palletDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletDescription, true), gettype($palletDescription)), __LINE__);
        }
        $this->PalletDescription = $palletDescription;
        return $this;
    }
    /**
     * Get NumOfPieces value
     * @return string|null
     */
    public function getNumOfPieces()
    {
        return $this->NumOfPieces;
    }
    /**
     * Set NumOfPieces value
     * @param string $numOfPieces
     * @return \StructType\PackageType
     */
    public function setNumOfPieces($numOfPieces = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPieces) && !is_string($numOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPieces, true), gettype($numOfPieces)), __LINE__);
        }
        $this->NumOfPieces = $numOfPieces;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \StructType\PackageType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Packaging value
     * @return \StructType\PackagingType|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param \StructType\PackagingType $packaging
     * @return \StructType\PackageType
     */
    public function setPackaging(\StructType\PackagingType $packaging = null)
    {
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \StructType\DimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \StructType\DimensionsType $dimensions
     * @return \StructType\PackageType
     */
    public function setDimensions(\StructType\DimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get DimWeight value
     * @return \StructType\PackageWeightType|null
     */
    public function getDimWeight()
    {
        return $this->DimWeight;
    }
    /**
     * Set DimWeight value
     * @param \StructType\PackageWeightType $dimWeight
     * @return \StructType\PackageType
     */
    public function setDimWeight(\StructType\PackageWeightType $dimWeight = null)
    {
        $this->DimWeight = $dimWeight;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \StructType\PackageWeightType|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \StructType\PackageWeightType $packageWeight
     * @return \StructType\PackageType
     */
    public function setPackageWeight(\StructType\PackageWeightType $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get LargePackageIndicator value
     * @return string|null
     */
    public function getLargePackageIndicator()
    {
        return $this->LargePackageIndicator;
    }
    /**
     * Set LargePackageIndicator value
     * @param string $largePackageIndicator
     * @return \StructType\PackageType
     */
    public function setLargePackageIndicator($largePackageIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($largePackageIndicator) && !is_string($largePackageIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largePackageIndicator, true), gettype($largePackageIndicator)), __LINE__);
        }
        $this->LargePackageIndicator = $largePackageIndicator;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \StructType\ReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$packageTypeReferenceNumberItem instanceof \StructType\ReferenceNumberType) {
                $invalidValues[] = is_object($packageTypeReferenceNumberItem) ? get_class($packageTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($packageTypeReferenceNumberItem), var_export($packageTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \StructType\ReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNumberType[] $referenceNumber
     * @return \StructType\PackageType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($referenceNumber) && count($referenceNumber) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNumberType $item
     * @return \StructType\PackageType
     */
    public function addToReferenceNumber(\StructType\ReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \StructType\ReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get AdditionalHandlingIndicator value
     * @return string|null
     */
    public function getAdditionalHandlingIndicator()
    {
        return $this->AdditionalHandlingIndicator;
    }
    /**
     * Set AdditionalHandlingIndicator value
     * @param string $additionalHandlingIndicator
     * @return \StructType\PackageType
     */
    public function setAdditionalHandlingIndicator($additionalHandlingIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($additionalHandlingIndicator) && !is_string($additionalHandlingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalHandlingIndicator, true), gettype($additionalHandlingIndicator)), __LINE__);
        }
        $this->AdditionalHandlingIndicator = $additionalHandlingIndicator;
        return $this;
    }
    /**
     * Get PackageServiceOptions value
     * @return \StructType\PackageServiceOptionsType|null
     */
    public function getPackageServiceOptions()
    {
        return $this->PackageServiceOptions;
    }
    /**
     * Set PackageServiceOptions value
     * @param \StructType\PackageServiceOptionsType $packageServiceOptions
     * @return \StructType\PackageType
     */
    public function setPackageServiceOptions(\StructType\PackageServiceOptionsType $packageServiceOptions = null)
    {
        $this->PackageServiceOptions = $packageServiceOptions;
        return $this;
    }
    /**
     * Get Commodity value
     * @return \StructType\CommodityType|null
     */
    public function getCommodity()
    {
        return $this->Commodity;
    }
    /**
     * Set Commodity value
     * @param \StructType\CommodityType $commodity
     * @return \StructType\PackageType
     */
    public function setCommodity(\StructType\CommodityType $commodity = null)
    {
        $this->Commodity = $commodity;
        return $this;
    }
    /**
     * Get HazMatPackageInformation value
     * @return \StructType\HazMatPackageInformationType|null
     */
    public function getHazMatPackageInformation()
    {
        return $this->HazMatPackageInformation;
    }
    /**
     * Set HazMatPackageInformation value
     * @param \StructType\HazMatPackageInformationType $hazMatPackageInformation
     * @return \StructType\PackageType
     */
    public function setHazMatPackageInformation(\StructType\HazMatPackageInformationType $hazMatPackageInformation = null)
    {
        $this->HazMatPackageInformation = $hazMatPackageInformation;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \StructType\CodeDescriptionType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \StructType\CodeDescriptionType $simpleRate
     * @return \StructType\PackageType
     */
    public function setSimpleRate(\StructType\CodeDescriptionType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get UPSPremier value
     * @return \StructType\UPSPremierType|null
     */
    public function getUPSPremier()
    {
        return $this->UPSPremier;
    }
    /**
     * Set UPSPremier value
     * @param \StructType\UPSPremierType $uPSPremier
     * @return \StructType\PackageType
     */
    public function setUPSPremier(\StructType\UPSPremierType $uPSPremier = null)
    {
        $this->UPSPremier = $uPSPremier;
        return $this;
    }
    /**
     * Get OversizeIndicator value
     * @return string|null
     */
    public function getOversizeIndicator()
    {
        return $this->OversizeIndicator;
    }
    /**
     * Set OversizeIndicator value
     * @param string $oversizeIndicator
     * @return \StructType\PackageType
     */
    public function setOversizeIndicator($oversizeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($oversizeIndicator) && !is_string($oversizeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oversizeIndicator, true), gettype($oversizeIndicator)), __LINE__);
        }
        $this->OversizeIndicator = $oversizeIndicator;
        return $this;
    }
    /**
     * Get MinimumBillableWeightIndicator value
     * @return string|null
     */
    public function getMinimumBillableWeightIndicator()
    {
        return $this->MinimumBillableWeightIndicator;
    }
    /**
     * Set MinimumBillableWeightIndicator value
     * @param string $minimumBillableWeightIndicator
     * @return \StructType\PackageType
     */
    public function setMinimumBillableWeightIndicator($minimumBillableWeightIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($minimumBillableWeightIndicator) && !is_string($minimumBillableWeightIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumBillableWeightIndicator, true), gettype($minimumBillableWeightIndicator)), __LINE__);
        }
        $this->MinimumBillableWeightIndicator = $minimumBillableWeightIndicator;
        return $this;
    }
}
