<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageServiceOptionsType StructType
 * @subpackage Structs
 */
class PackageServiceOptionsType extends AbstractStructBase
{
    /**
     * The DeliveryConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryConfirmationType
     */
    public $DeliveryConfirmation;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageDeclaredValueType
     */
    public $DeclaredValue;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PSOCODType
     */
    public $COD;
    /**
     * The AccessPointCOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageServiceOptionsAccessPointCODType
     */
    public $AccessPointCOD;
    /**
     * The ShipperReleaseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperReleaseIndicator;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PSONotificationType
     */
    public $Notification;
    /**
     * The HazMat
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\HazMatType[]
     */
    public $HazMat;
    /**
     * The DryIce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DryIceType
     */
    public $DryIce;
    /**
     * The UPSPremiumCareIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPSPremiumCareIndicator;
    /**
     * The ProactiveIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProactiveIndicator;
    /**
     * The PackageIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIdentifier;
    /**
     * The ClinicalTrialsID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClinicalTrialsID;
    /**
     * The RefrigerationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RefrigerationIndicator;
    /**
     * Constructor method for PackageServiceOptionsType
     * @uses PackageServiceOptionsType::setDeliveryConfirmation()
     * @uses PackageServiceOptionsType::setDeclaredValue()
     * @uses PackageServiceOptionsType::setCOD()
     * @uses PackageServiceOptionsType::setAccessPointCOD()
     * @uses PackageServiceOptionsType::setShipperReleaseIndicator()
     * @uses PackageServiceOptionsType::setNotification()
     * @uses PackageServiceOptionsType::setHazMat()
     * @uses PackageServiceOptionsType::setDryIce()
     * @uses PackageServiceOptionsType::setUPSPremiumCareIndicator()
     * @uses PackageServiceOptionsType::setProactiveIndicator()
     * @uses PackageServiceOptionsType::setPackageIdentifier()
     * @uses PackageServiceOptionsType::setClinicalTrialsID()
     * @uses PackageServiceOptionsType::setRefrigerationIndicator()
     * @param \StructType\DeliveryConfirmationType $deliveryConfirmation
     * @param \StructType\PackageDeclaredValueType $declaredValue
     * @param \StructType\PSOCODType $cOD
     * @param \StructType\PackageServiceOptionsAccessPointCODType $accessPointCOD
     * @param string $shipperReleaseIndicator
     * @param \StructType\PSONotificationType $notification
     * @param \StructType\HazMatType[] $hazMat
     * @param \StructType\DryIceType $dryIce
     * @param string $uPSPremiumCareIndicator
     * @param string $proactiveIndicator
     * @param string $packageIdentifier
     * @param string $clinicalTrialsID
     * @param string $refrigerationIndicator
     */
    public function __construct(\StructType\DeliveryConfirmationType $deliveryConfirmation = null, \StructType\PackageDeclaredValueType $declaredValue = null, \StructType\PSOCODType $cOD = null, \StructType\PackageServiceOptionsAccessPointCODType $accessPointCOD = null, $shipperReleaseIndicator = null, \StructType\PSONotificationType $notification = null, array $hazMat = array(), \StructType\DryIceType $dryIce = null, $uPSPremiumCareIndicator = null, $proactiveIndicator = null, $packageIdentifier = null, $clinicalTrialsID = null, $refrigerationIndicator = null)
    {
        $this
            ->setDeliveryConfirmation($deliveryConfirmation)
            ->setDeclaredValue($declaredValue)
            ->setCOD($cOD)
            ->setAccessPointCOD($accessPointCOD)
            ->setShipperReleaseIndicator($shipperReleaseIndicator)
            ->setNotification($notification)
            ->setHazMat($hazMat)
            ->setDryIce($dryIce)
            ->setUPSPremiumCareIndicator($uPSPremiumCareIndicator)
            ->setProactiveIndicator($proactiveIndicator)
            ->setPackageIdentifier($packageIdentifier)
            ->setClinicalTrialsID($clinicalTrialsID)
            ->setRefrigerationIndicator($refrigerationIndicator);
    }
    /**
     * Get DeliveryConfirmation value
     * @return \StructType\DeliveryConfirmationType|null
     */
    public function getDeliveryConfirmation()
    {
        return $this->DeliveryConfirmation;
    }
    /**
     * Set DeliveryConfirmation value
     * @param \StructType\DeliveryConfirmationType $deliveryConfirmation
     * @return \StructType\PackageServiceOptionsType
     */
    public function setDeliveryConfirmation(\StructType\DeliveryConfirmationType $deliveryConfirmation = null)
    {
        $this->DeliveryConfirmation = $deliveryConfirmation;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return \StructType\PackageDeclaredValueType|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param \StructType\PackageDeclaredValueType $declaredValue
     * @return \StructType\PackageServiceOptionsType
     */
    public function setDeclaredValue(\StructType\PackageDeclaredValueType $declaredValue = null)
    {
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get COD value
     * @return \StructType\PSOCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \StructType\PSOCODType $cOD
     * @return \StructType\PackageServiceOptionsType
     */
    public function setCOD(\StructType\PSOCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get AccessPointCOD value
     * @return \StructType\PackageServiceOptionsAccessPointCODType|null
     */
    public function getAccessPointCOD()
    {
        return $this->AccessPointCOD;
    }
    /**
     * Set AccessPointCOD value
     * @param \StructType\PackageServiceOptionsAccessPointCODType $accessPointCOD
     * @return \StructType\PackageServiceOptionsType
     */
    public function setAccessPointCOD(\StructType\PackageServiceOptionsAccessPointCODType $accessPointCOD = null)
    {
        $this->AccessPointCOD = $accessPointCOD;
        return $this;
    }
    /**
     * Get ShipperReleaseIndicator value
     * @return string|null
     */
    public function getShipperReleaseIndicator()
    {
        return $this->ShipperReleaseIndicator;
    }
    /**
     * Set ShipperReleaseIndicator value
     * @param string $shipperReleaseIndicator
     * @return \StructType\PackageServiceOptionsType
     */
    public function setShipperReleaseIndicator($shipperReleaseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($shipperReleaseIndicator) && !is_string($shipperReleaseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperReleaseIndicator, true), gettype($shipperReleaseIndicator)), __LINE__);
        }
        $this->ShipperReleaseIndicator = $shipperReleaseIndicator;
        return $this;
    }
    /**
     * Get Notification value
     * @return \StructType\PSONotificationType|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \StructType\PSONotificationType $notification
     * @return \StructType\PackageServiceOptionsType
     */
    public function setNotification(\StructType\PSONotificationType $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get HazMat value
     * @return \StructType\HazMatType[]|null
     */
    public function getHazMat()
    {
        return $this->HazMat;
    }
    /**
     * This method is responsible for validating the values passed to the setHazMat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazMat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazMatForArrayConstraintsFromSetHazMat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageServiceOptionsTypeHazMatItem) {
            // validation for constraint: itemType
            if (!$packageServiceOptionsTypeHazMatItem instanceof \StructType\HazMatType) {
                $invalidValues[] = is_object($packageServiceOptionsTypeHazMatItem) ? get_class($packageServiceOptionsTypeHazMatItem) : sprintf('%s(%s)', gettype($packageServiceOptionsTypeHazMatItem), var_export($packageServiceOptionsTypeHazMatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazMat property can only contain items of type \StructType\HazMatType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazMat value
     * @throws \InvalidArgumentException
     * @param \StructType\HazMatType[] $hazMat
     * @return \StructType\PackageServiceOptionsType
     */
    public function setHazMat(array $hazMat = array())
    {
        // validation for constraint: array
        if ('' !== ($hazMatArrayErrorMessage = self::validateHazMatForArrayConstraintsFromSetHazMat($hazMat))) {
            throw new \InvalidArgumentException($hazMatArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($hazMat) && count($hazMat) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($hazMat)), __LINE__);
        }
        $this->HazMat = $hazMat;
        return $this;
    }
    /**
     * Add item to HazMat value
     * @throws \InvalidArgumentException
     * @param \StructType\HazMatType $item
     * @return \StructType\PackageServiceOptionsType
     */
    public function addToHazMat(\StructType\HazMatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HazMatType) {
            throw new \InvalidArgumentException(sprintf('The HazMat property can only contain items of type \StructType\HazMatType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->HazMat) && count($this->HazMat) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->HazMat)), __LINE__);
        }
        $this->HazMat[] = $item;
        return $this;
    }
    /**
     * Get DryIce value
     * @return \StructType\DryIceType|null
     */
    public function getDryIce()
    {
        return $this->DryIce;
    }
    /**
     * Set DryIce value
     * @param \StructType\DryIceType $dryIce
     * @return \StructType\PackageServiceOptionsType
     */
    public function setDryIce(\StructType\DryIceType $dryIce = null)
    {
        $this->DryIce = $dryIce;
        return $this;
    }
    /**
     * Get UPSPremiumCareIndicator value
     * @return string|null
     */
    public function getUPSPremiumCareIndicator()
    {
        return $this->UPSPremiumCareIndicator;
    }
    /**
     * Set UPSPremiumCareIndicator value
     * @param string $uPSPremiumCareIndicator
     * @return \StructType\PackageServiceOptionsType
     */
    public function setUPSPremiumCareIndicator($uPSPremiumCareIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($uPSPremiumCareIndicator) && !is_string($uPSPremiumCareIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPSPremiumCareIndicator, true), gettype($uPSPremiumCareIndicator)), __LINE__);
        }
        $this->UPSPremiumCareIndicator = $uPSPremiumCareIndicator;
        return $this;
    }
    /**
     * Get ProactiveIndicator value
     * @return string|null
     */
    public function getProactiveIndicator()
    {
        return $this->ProactiveIndicator;
    }
    /**
     * Set ProactiveIndicator value
     * @param string $proactiveIndicator
     * @return \StructType\PackageServiceOptionsType
     */
    public function setProactiveIndicator($proactiveIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($proactiveIndicator) && !is_string($proactiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proactiveIndicator, true), gettype($proactiveIndicator)), __LINE__);
        }
        $this->ProactiveIndicator = $proactiveIndicator;
        return $this;
    }
    /**
     * Get PackageIdentifier value
     * @return string|null
     */
    public function getPackageIdentifier()
    {
        return $this->PackageIdentifier;
    }
    /**
     * Set PackageIdentifier value
     * @param string $packageIdentifier
     * @return \StructType\PackageServiceOptionsType
     */
    public function setPackageIdentifier($packageIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($packageIdentifier) && !is_string($packageIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIdentifier, true), gettype($packageIdentifier)), __LINE__);
        }
        $this->PackageIdentifier = $packageIdentifier;
        return $this;
    }
    /**
     * Get ClinicalTrialsID value
     * @return string|null
     */
    public function getClinicalTrialsID()
    {
        return $this->ClinicalTrialsID;
    }
    /**
     * Set ClinicalTrialsID value
     * @param string $clinicalTrialsID
     * @return \StructType\PackageServiceOptionsType
     */
    public function setClinicalTrialsID($clinicalTrialsID = null)
    {
        // validation for constraint: string
        if (!is_null($clinicalTrialsID) && !is_string($clinicalTrialsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clinicalTrialsID, true), gettype($clinicalTrialsID)), __LINE__);
        }
        $this->ClinicalTrialsID = $clinicalTrialsID;
        return $this;
    }
    /**
     * Get RefrigerationIndicator value
     * @return string|null
     */
    public function getRefrigerationIndicator()
    {
        return $this->RefrigerationIndicator;
    }
    /**
     * Set RefrigerationIndicator value
     * @param string $refrigerationIndicator
     * @return \StructType\PackageServiceOptionsType
     */
    public function setRefrigerationIndicator($refrigerationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($refrigerationIndicator) && !is_string($refrigerationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refrigerationIndicator, true), gettype($refrigerationIndicator)), __LINE__);
        }
        $this->RefrigerationIndicator = $refrigerationIndicator;
        return $this;
    }
}
